/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.ActiveLock;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Property;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LockDiscovery
extends Property {
    protected static final String[] childNames = new String[]{"activelock"};

    public LockDiscovery(Element root) throws MalformedElementException {
        super(root, "lockdiscovery");
    }

    public ActiveLock addActiveLock() {
        Element activelock = ElementEditor.addChild(this.root, "activelock", childNames, false);
        Element locktype = ElementEditor.appendChild(activelock, "locktype");
        ElementEditor.appendChild(locktype, "write");
        ActiveLock result = null;
        try {
            result = new ActiveLock(activelock);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public Enumeration getActiveLocks() throws MalformedElementException {
        Element firstActiveLock = ElementEditor.getFirstChild(this.root, "activelock");
        Enumeration e = new Enumeration(firstActiveLock){
            Node currentActiveLock;
            {
                this.currentActiveLock = node;
            }

            public boolean hasMoreElements() {
                return this.currentActiveLock != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                ActiveLock result = null;
                try {
                    result = new ActiveLock((Element)this.currentActiveLock);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                this.currentActiveLock = ElementEditor.getTwin((Element)this.currentActiveLock, true);
                return result;
            }
        };
        return e;
    }
}

