/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete;

import java.util.HashSet;
import java.util.List;
import org.drools.eclipse.editors.rete.RowList;
import org.drools.eclipse.editors.rete.model.Connection;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.drools.reteoo.BaseVertex;
import org.eclipse.draw2d.geometry.Point;

public class ReteooLayoutFactory {
    public static RowList calculateReteRows(BaseVertex root) {
        RowList rowList = new RowList();
        rowList.add(0, root);
        int curRow = 0;
        HashSet<BaseVertex> seenVertices = new HashSet<BaseVertex>();
        seenVertices.add(root);
        while (curRow < rowList.getDepth()) {
            List rowVertices = rowList.get(curRow).getVertices();
            for (BaseVertex rowNode : rowVertices) {
                List edges = rowNode.getSourceConnections();
                for (Connection edge : edges) {
                    BaseVertex destNode = edge.getOpposite(rowNode);
                    if (seenVertices.contains(destNode)) continue;
                    rowList.add(curRow + 1, destNode);
                    seenVertices.add(destNode);
                }
                seenVertices.add(rowNode);
            }
            ++curRow;
        }
        rowList.optimize();
        return rowList;
    }

    public static void layoutRowList(ReteGraph graph, RowList rowList) {
        new LayoutCalculator(graph, rowList);
    }

    private static class LayoutCalculator {
        public static final String COORDS = "drools.LayoutCalculator.coords";
        private static final int COLUMN_SPACE = 40;
        private static final int ROW_HEIGHT_MULTIPLIER = 6;
        private RowList rowList;
        private int columnWidth;
        private int rowHeight;
        private ReteGraph graph;

        private LayoutCalculator(ReteGraph graph, RowList rowList) {
            this.graph = graph;
            this.rowList = rowList;
            this.computeSize();
            List vertices = this.getGraph().getChildren();
            for (BaseVertex v : vertices) {
                this.initialize_local_vertex(v);
            }
        }

        private void computeSize() {
            List vertices = this.getGraph().getChildren();
            for (BaseVertex vertex : vertices) {
                int width = vertex.getSize().width;
                int height = vertex.getSize().height;
                if (width > this.columnWidth) {
                    this.columnWidth = width;
                }
                if (height <= this.rowHeight) continue;
                this.rowHeight = height;
            }
            this.columnWidth += 40;
        }

        private void initialize_local_vertex(BaseVertex vertex) {
            int row = this.rowList.getRow(vertex);
            int col = this.rowList.getColumn(vertex);
            int rowWidth = this.rowList.getWidth(row);
            int columnWidthPx = this.columnWidth;
            int rowHeightPx = this.rowHeight;
            double x = col * columnWidthPx;
            double y = row * (rowHeightPx * 6);
            x = x + (double)(columnWidthPx / 2) - (double)((rowWidth - 1) * (columnWidthPx / 2));
            y = y + (double)(rowHeightPx / 2) + 3.0;
            vertex.setLocation(new Point(x, y));
        }

        private ReteGraph getGraph() {
            return this.graph;
        }
    }
}

