/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Prop;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropFind
extends ElementEditor {
    protected static final String[] childNames = new String[]{"allprop", "propname", "prop"};

    public PropFind(Element root) throws MalformedElementException {
        super(root, "propfind");
    }

    public static PropFind create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Element element = ElementEditor.create(document, "propfind");
        try {
            return new PropFind(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public Prop getProp() throws MalformedElementException {
        Element prop = ElementEditor.getFirstChild(this.root, "prop");
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingPropElmt"), prop);
        return new Prop(prop);
    }

    public boolean isAllProp() throws MalformedElementException {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingAllpropOrPropnameOrPropElmt"), child);
        boolean isAllProp = ElementEditor.isDAVElement(child, "allprop");
        child = ElementEditor.getNextSibling(child, childNames);
        ElementEditor.ensureNull(Policy.bind("ensure.conflictingAllpropOrPropnameOrPropElmt"), child);
        return isAllProp;
    }

    public boolean isProp() throws MalformedElementException {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingAllpropOrPropnameOrPropElmt"), child);
        boolean isProp = ElementEditor.isDAVElement(child, "prop");
        child = ElementEditor.getNextSibling(child, childNames);
        ElementEditor.ensureNull(Policy.bind("ensure.conflictingAllpropOrPropnameOrPropElmt"), child);
        return isProp;
    }

    public boolean isPropName() throws MalformedElementException {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingAllpropOrPropnameOrPropElmt"), child);
        boolean isPropName = ElementEditor.isDAVElement(child, "propname");
        child = ElementEditor.getNextSibling(child, childNames);
        ElementEditor.ensureNull(Policy.bind("ensure.conflictingAllpropOrPropnameOrPropElmt"), child);
        return isPropName;
    }

    public void setIsAllProp(boolean isAllProp) {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        boolean isAlreadyAllProp = ElementEditor.isDAVElement(child, "allprop");
        if (isAllProp) {
            if (!isAlreadyAllProp) {
                if (child != null) {
                    this.root.removeChild(child);
                }
                ElementEditor.appendChild(this.root, "allprop");
            }
        } else if (isAlreadyAllProp) {
            this.root.removeChild(child);
        }
    }

    public void setIsPropName(boolean isPropName) {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        boolean isAlreadyPropName = ElementEditor.isDAVElement(child, "propname");
        if (isPropName) {
            if (!isAlreadyPropName) {
                if (child != null) {
                    this.root.removeChild(child);
                }
                ElementEditor.appendChild(this.root, "propname");
            }
        } else if (isAlreadyPropName) {
            this.root.removeChild(child);
        }
    }

    public Prop setProp() {
        Assert.isTrue(ElementEditor.getFirstChild(this.root, new String[]{"allprop", "propname"}) == null);
        Element prop = ElementEditor.setChild(this.root, "prop", new String[]{"prop"}, true);
        try {
            return new Prop(prop);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }
}

