/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.FactTemplateError;
import org.drools.compiler.FieldTemplateError;
import org.drools.compiler.FunctionError;
import org.drools.compiler.GlobalError;
import org.drools.compiler.ImportError;
import org.drools.compiler.ParserError;
import org.drools.compiler.RuleBuildError;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.builder.DroolsBuildMarker;
import org.drools.eclipse.builder.Util;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.ide.common.server.util.GuidedDTDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTXMLPersistence;
import org.drools.lang.ExpanderException;
import org.drools.template.parser.DecisionTableParseException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class DroolsBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.drools.eclipse.droolsbuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !currentProject.isAccessible()) {
            return new IProject[0];
        }
        try {
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (CoreException e) {
            IMarker marker = currentProject.createMarker("org.drools.eclipse.problem");
            marker.setAttribute("message", (Object)("Error when trying to build Drools project: " + e.getLocalizedMessage()));
            marker.setAttribute("severity", 2);
        }
        return this.getRequiredProjects(currentProject);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.removeProblemsFor((IResource)this.getProject());
        IJavaProject project = JavaCore.create((IProject)this.getProject());
        IClasspathEntry[] classpathEntries = project.getRawClasspath();
        int i = 0;
        while (i < classpathEntries.length) {
            String[] jars;
            if ("DROOLS/Drools".equals(classpathEntries[i].getPath().toString()) && ((jars = DroolsRuntimeManager.getDroolsRuntimeJars(this.getProject())) == null || jars.length == 0)) {
                String runtime = DroolsRuntimeManager.getDroolsRuntime(this.getProject());
                IMarker marker = this.getProject().createMarker("org.drools.eclipse.problem");
                if (runtime == null) {
                    marker.setAttribute("message", (Object)"Could not find default Drools runtime");
                } else {
                    marker.setAttribute("message", (Object)("Could not find Drools runtime " + runtime));
                }
                marker.setAttribute("severity", 2);
                return;
            }
            ++i;
        }
        this.getProject().accept((IResourceVisitor)new DroolsBuildVisitor());
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        boolean buildAll = DroolsEclipsePlugin.getDefault().getPreferenceStore().getBoolean("Drools.BuildAll");
        if (buildAll) {
            this.fullBuild(monitor);
        } else {
            delta.accept((IResourceDeltaVisitor)new DroolsBuildDeltaVisitor());
        }
    }

    protected boolean parseResource(IResource res, boolean clean) {
        DroolsBuildMarker[] markers;
        block35: {
            try {
                if (!".guvnorinfo".equals(res.getName())) break block35;
                return false;
            }
            catch (JavaModelException javaModelException) {}
        }
        IJavaProject project = JavaCore.create((IProject)res.getProject());
        if (!project.getOutputLocation().equals((Object)project.getPath()) && project.getOutputLocation().isPrefixOf(res.getFullPath())) {
            return false;
        }
        if (!res.exists()) {
            this.removeProblemsFor(res);
            DroolsEclipsePlugin.getDefault().invalidateResource(res);
            return false;
        }
        if (res instanceof IFile && ("drl".equals(res.getFileExtension()) || "dslr".equals(res.getFileExtension()) || ".package".equals(res.getName()))) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                markers = this.parseDRLFile((IFile)res, new String(Util.getResourceContentsAsCharArray((IFile)res)));
                int i = 0;
                while (i < markers.length) {
                    this.createMarker(res, markers[i].getText(), markers[i].getLine());
                    ++i;
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && "xls".equals(res.getFileExtension())) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                markers = this.parseXLSFile((IFile)res);
                int i = 0;
                while (i < markers.length) {
                    this.createMarker(res, markers[i].getText(), markers[i].getLine());
                    ++i;
                }
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && "csv".equals(res.getFileExtension())) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                markers = this.parseCSVFile((IFile)res);
                int i = 0;
                while (i < markers.length) {
                    this.createMarker(res, markers[i].getText(), markers[i].getLine());
                    ++i;
                }
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && "brl".equals(res.getFileExtension())) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                markers = this.parseBRLFile((IFile)res);
                int i = 0;
                while (i < markers.length) {
                    this.createMarker(res, markers[i].getText(), markers[i].getLine());
                    ++i;
                }
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && "rf".equals(res.getFileExtension())) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                markers = this.parseRuleFlowFile((IFile)res);
                int i = 0;
                while (i < markers.length) {
                    this.createMarker(res, markers[i].getText(), markers[i].getLine());
                    ++i;
                }
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && ("bpmn".equals(res.getFileExtension()) || "bpmn2".equals(res.getFileExtension()))) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                markers = this.parseRuleFlowFile((IFile)res);
                int i = 0;
                while (i < markers.length) {
                    this.createMarker(res, markers[i].getText(), markers[i].getLine());
                    ++i;
                }
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        return true;
    }

    private DroolsBuildMarker[] parseDRLFile(IFile file, String content) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        try {
            DRLInfo drlInfo = DroolsEclipsePlugin.getDefault().parseResource((IResource)file, true);
            this.markParseErrors(markers, drlInfo.getParserErrors());
            this.markOtherErrors(markers, drlInfo.getBuilderErrors());
        }
        catch (DroolsParserException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RecognitionException) {
                RecognitionException recogErr = (RecognitionException)cause;
                markers.add(new DroolsBuildMarker(recogErr.getMessage(), recogErr.line));
            }
        }
        catch (Exception t) {
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers.toArray(new DroolsBuildMarker[markers.size()]);
    }

    private DroolsBuildMarker[] parseXLSFile(IFile file) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        try {
            SpreadsheetCompiler converter = new SpreadsheetCompiler();
            String drl = converter.compile(file.getContents(), InputType.XLS);
            DRLInfo drlInfo = DroolsEclipsePlugin.getDefault().parseXLSResource(drl, (IResource)file);
            this.markParseErrors(markers, drlInfo.getParserErrors());
            this.markOtherErrors(markers, drlInfo.getBuilderErrors());
        }
        catch (DroolsParserException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RecognitionException) {
                RecognitionException recogErr = (RecognitionException)cause;
                markers.add(new DroolsBuildMarker(recogErr.getMessage(), recogErr.line));
            }
        }
        catch (DecisionTableParseException e) {
            if (!"No RuleTable's were found in spreadsheet.".equals(e.getMessage())) {
                throw e;
            }
        }
        catch (Exception t) {
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers.toArray(new DroolsBuildMarker[markers.size()]);
    }

    private DroolsBuildMarker[] parseCSVFile(IFile file) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        try {
            SpreadsheetCompiler converter = new SpreadsheetCompiler();
            String drl = converter.compile(file.getContents(), InputType.CSV);
            DRLInfo drlInfo = DroolsEclipsePlugin.getDefault().parseXLSResource(drl, (IResource)file);
            this.markParseErrors(markers, drlInfo.getParserErrors());
            this.markOtherErrors(markers, drlInfo.getBuilderErrors());
        }
        catch (DroolsParserException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RecognitionException) {
                RecognitionException recogErr = (RecognitionException)cause;
                markers.add(new DroolsBuildMarker(recogErr.getMessage(), recogErr.line));
            }
        }
        catch (Exception t) {
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers.toArray(new DroolsBuildMarker[markers.size()]);
    }

    private DroolsBuildMarker[] parseBRLFile(IFile file) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        try {
            String brl = DroolsBuilder.convertToString(file.getContents());
            RuleModel model = BRXMLPersistence.getInstance().unmarshal(brl);
            String drl = BRDRLPersistence.getInstance().marshal(model);
            DRLInfo drlInfo = DroolsEclipsePlugin.getDefault().parseBRLResource(drl, (IResource)file);
            this.markParseErrors(markers, drlInfo.getParserErrors());
            this.markOtherErrors(markers, drlInfo.getBuilderErrors());
        }
        catch (DroolsParserException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RecognitionException) {
                RecognitionException recogErr = (RecognitionException)cause;
                markers.add(new DroolsBuildMarker(recogErr.getMessage(), recogErr.line));
            }
        }
        catch (Exception t) {
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers.toArray(new DroolsBuildMarker[markers.size()]);
    }

    private DroolsBuildMarker[] parseGDSTFile(IFile file) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        try {
            String gdst = DroolsBuilder.convertToString(file.getContents());
            GuidedDecisionTable52 dt = GuidedDTXMLPersistence.getInstance().unmarshal(gdst);
            String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
            DRLInfo drlInfo = DroolsEclipsePlugin.getDefault().parseGDSTResource(drl, (IResource)file);
            this.markParseErrors(markers, drlInfo.getParserErrors());
            this.markOtherErrors(markers, drlInfo.getBuilderErrors());
        }
        catch (DroolsParserException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RecognitionException) {
                RecognitionException recogErr = (RecognitionException)cause;
                markers.add(new DroolsBuildMarker(recogErr.getMessage(), recogErr.line));
            }
        }
        catch (Exception t) {
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers.toArray(new DroolsBuildMarker[markers.size()]);
    }

    protected DroolsBuildMarker[] parseRuleFlowFile(IFile file) {
        if (!file.exists()) {
            return new DroolsBuildMarker[0];
        }
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        try {
            String input = DroolsBuilder.convertToString(file.getContents());
            ProcessInfo processInfo = DroolsEclipsePlugin.getDefault().parseProcess(input, (IResource)file);
            if (processInfo != null) {
                this.markParseErrors(markers, processInfo.getErrors());
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers.toArray(new DroolsBuildMarker[markers.size()]);
    }

    protected static String convertToString(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    protected void markParseErrors(List markers, List parserErrors) {
        for (Object error : parserErrors) {
            if (error instanceof ParserError) {
                ParserError err = (ParserError)error;
                markers.add(new DroolsBuildMarker(err.getMessage(), err.getRow()));
                continue;
            }
            if (error instanceof ExpanderException) {
                ExpanderException exc = (ExpanderException)error;
                markers.add(new DroolsBuildMarker(exc.getMessage(), -1));
                continue;
            }
            markers.add(new DroolsBuildMarker(error.toString()));
        }
    }

    private void markOtherErrors(List markers, DroolsError[] buildErrors) {
        int i = 0;
        while (i < buildErrors.length) {
            int j;
            CompilationProblem[] problems;
            DroolsError error = buildErrors[i];
            if (error instanceof GlobalError) {
                GlobalError globalError = (GlobalError)error;
                markers.add(new DroolsBuildMarker("Global error: " + globalError.getGlobal(), -1));
            } else if (error instanceof RuleBuildError) {
                RuleBuildError ruleError = (RuleBuildError)error;
                if (ruleError.getObject() instanceof CompilationProblem[]) {
                    problems = (CompilationProblem[])ruleError.getObject();
                    j = 0;
                    while (j < problems.length) {
                        markers.add(new DroolsBuildMarker(problems[j].getMessage(), ruleError.getLine()));
                        ++j;
                    }
                } else {
                    markers.add(new DroolsBuildMarker(String.valueOf(ruleError.getRule().getName()) + ":" + ruleError.getMessage(), ruleError.getLine()));
                }
            } else if (error instanceof ParserError) {
                ParserError parserError = (ParserError)error;
                markers.add(new DroolsBuildMarker(parserError.getMessage(), parserError.getRow()));
            } else if (error instanceof FunctionError) {
                FunctionError functionError = (FunctionError)error;
                if (functionError.getObject() instanceof CompilationProblem[]) {
                    problems = (CompilationProblem[])functionError.getObject();
                    j = 0;
                    while (j < problems.length) {
                        markers.add(new DroolsBuildMarker(problems[j].getMessage(), functionError.getLines()[j]));
                        ++j;
                    }
                } else {
                    markers.add(new DroolsBuildMarker(String.valueOf(functionError.getFunctionDescr().getName()) + ":" + functionError.getMessage(), -1));
                }
            } else if (error instanceof FieldTemplateError) {
                markers.add(new DroolsBuildMarker(error.getMessage(), ((FieldTemplateError)error).getLine()));
            } else if (error instanceof FactTemplateError) {
                markers.add(new DroolsBuildMarker(error.getMessage(), ((FactTemplateError)error).getLine()));
            } else if (error instanceof ImportError) {
                markers.add(new DroolsBuildMarker("ImportError: " + error.getMessage()));
            } else if (error instanceof DescrBuildError) {
                markers.add(new DroolsBuildMarker("BuildError: " + error.getMessage(), ((DescrBuildError)error).getLine()));
            } else {
                markers.add(new DroolsBuildMarker("Unknown DroolsError " + error.getClass() + ": " + error));
            }
            ++i;
        }
    }

    protected void createMarker(final IResource res, final String message, final int lineNumber) {
        try {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker = res.createMarker("org.drools.eclipse.problem");
                    marker.setAttribute("message", (Object)message);
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("lineNumber", lineNumber);
                }
            };
            res.getWorkspace().run(r, null, 1, null);
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    protected void removeProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.drools.eclipse.problem", false, 2);
            }
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    private IProject[] getRequiredProjects(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IProject p;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && (p = project.getWorkspace().getRoot().getProject(entry.getPath().lastSegment())) != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    private class DroolsBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        private DroolsBuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            return DroolsBuilder.this.parseResource(delta.getResource(), false);
        }
    }

    private class DroolsBuildVisitor
    implements IResourceVisitor {
        private DroolsBuildVisitor() {
        }

        public boolean visit(IResource res) {
            return DroolsBuilder.this.parseResource(res, true);
        }
    }
}

