/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.preferences.IDroolsConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DroolsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button buildAllCheckBox;
    private Button collapseEditorCheckBox;
    private Button cacheParsedRulesCheckBox;
    private Combo processSkinCombo;
    private Button allowNodeCustomizationCheckBox;
    private Combo internalAPICombo;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.buildAllCheckBox = this.createCheckBox(composite, "Automatically reparse all rules if a Java resource is changed.");
        this.collapseEditorCheckBox = this.createCheckBox(composite, "Use code folding in DRL editor.");
        this.cacheParsedRulesCheckBox = this.createCheckBox(composite, "When parsing rules, always cache the result for future use. Warning: when disabled, debugging of rules will not work.");
        Label label = new Label(composite, 0);
        label.setText("Preferred process skin: ");
        this.processSkinCombo = new Combo(composite, 16392);
        this.processSkinCombo.add("default");
        this.processSkinCombo.add("BPMN");
        this.processSkinCombo.add("BPMN2");
        this.allowNodeCustomizationCheckBox = this.createCheckBox(composite, "Allow the customization of process nodes.");
        label = new Label(composite, 0);
        label.setText("Internal Drools classes are: ");
        this.internalAPICombo = new Combo(composite, 16384);
        IDroolsConstants.InternalApiChoice[] internalApiChoiceArray = IDroolsConstants.InternalApiChoice.values();
        int n = internalApiChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDroolsConstants.InternalApiChoice choice = internalApiChoiceArray[n2];
            this.internalAPICombo.add(choice.toString());
            ++n2;
        }
        this.initializeValues();
        return composite;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DroolsEclipsePlugin.getDefault().getPreferenceStore();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.buildAllCheckBox.setSelection(store.getDefaultBoolean("Drools.BuildAll"));
        this.collapseEditorCheckBox.setSelection(store.getDefaultBoolean("Drools.EditorFolding"));
        this.cacheParsedRulesCheckBox.setSelection(store.getDefaultBoolean("Drools.CacheParsedRules"));
        String skin = store.getDefaultString("Drools.Flow.Skin");
        int index = 0;
        if ("BPMN".equals(skin)) {
            index = 1;
        }
        this.processSkinCombo.select(index);
        this.allowNodeCustomizationCheckBox.setSelection(store.getDefaultBoolean("Drools.Flow.AllowNodeCustomization"));
        this.internalAPICombo.select(store.getDefaultInt("Drools.Flow.AllowNodeCustomization"));
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.buildAllCheckBox.setSelection(store.getBoolean("Drools.BuildAll"));
        this.collapseEditorCheckBox.setSelection(store.getBoolean("Drools.EditorFolding"));
        this.cacheParsedRulesCheckBox.setSelection(store.getBoolean("Drools.CacheParsedRules"));
        String skin = store.getString("Drools.Flow.Skin");
        int index = 0;
        if ("BPMN".equals(skin)) {
            index = 1;
        }
        if ("BPMN2".equals(skin)) {
            index = 2;
        }
        this.processSkinCombo.select(index);
        this.allowNodeCustomizationCheckBox.setSelection(store.getBoolean("Drools.Flow.AllowNodeCustomization"));
        this.internalAPICombo.select(store.getInt("Drools.InternalAPI"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        DroolsEclipsePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("Drools.BuildAll", this.buildAllCheckBox.getSelection());
        store.setValue("Drools.EditorFolding", this.collapseEditorCheckBox.getSelection());
        store.setValue("Drools.CacheParsedRules", this.cacheParsedRulesCheckBox.getSelection());
        store.setValue("Drools.Flow.Skin", this.processSkinCombo.getItem(this.processSkinCombo.getSelectionIndex()));
        store.setValue("Drools.Flow.AllowNodeCustomization", this.allowNodeCustomizationCheckBox.getSelection());
        store.setValue("Drools.InternalAPI", this.internalAPICombo.getSelectionIndex());
    }

    public void init(IWorkbench workbench) {
    }
}

