/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AssignFieldVariableDialog
extends RuleDialog {
    private final FormToolkit toolkit;
    private RuleModeller modeller;
    private SingleFieldConstraint con;
    private final FactPattern pattern;

    public AssignFieldVariableDialog(Shell parent, FormToolkit toolkit, RuleModeller modeller, SingleFieldConstraint con, FactPattern pattern) {
        super(parent, "Bind the field called [" + con.getFieldName() + "] to a variable.", "Type the variable name and hit the button.");
        this.toolkit = toolkit;
        this.modeller = modeller;
        this.con = con;
        this.pattern = pattern;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout l = new GridLayout();
        l.numColumns = 5;
        l.marginBottom = 0;
        l.marginHeight = 0;
        l.marginLeft = 0;
        l.marginRight = 0;
        l.marginTop = 0;
        l.marginWidth = 0;
        composite.setLayout((Layout)l);
        this.createVariableBindingRow(composite);
        this.createSubfieldConstraintRow(composite);
        this.toolkit.paintBordersFor(composite);
        return composite;
    }

    private void createSubfieldConstraintRow(Composite composite) {
        SuggestionCompletionEngine engine = this.modeller.getSuggestionCompletionEngine();
        String[] fields = engine.getFieldCompletions(this.con.getFieldType());
        if (fields == null || fields.length <= 0) {
            return;
        }
        this.createLabel(composite, "Add a restriction on a subfield");
        final Combo combo = new Combo(composite, 12);
        combo.add("...");
        int i = 0;
        while (i < fields.length) {
            String field = fields[i];
            combo.add(field);
            combo.setData(field, (Object)engine.getFieldType(String.valueOf(this.con.getFieldType()) + "." + field));
            ++i;
        }
        combo.select(0);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String fName = combo.getText();
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AssignFieldVariableDialog.this.pattern.addConstraint((FieldConstraint)new SingleFieldConstraint(AssignFieldVariableDialog.this.pattern.getFactType(), fName, (String)combo.getData(fName), (FieldConstraint)AssignFieldVariableDialog.this.con));
                AssignFieldVariableDialog.this.modeller.setDirty(true);
                AssignFieldVariableDialog.this.modeller.reloadLhs();
                AssignFieldVariableDialog.this.close();
            }
        });
    }

    private void createVariableBindingRow(Composite composite) {
        this.createLabel(composite, "Variable name");
        final Text variableText = this.toolkit.createText(composite, "");
        if (this.con.getFieldBinding() != null) {
            variableText.setText(this.con.getFieldBinding());
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        variableText.setLayoutData((Object)gd);
        Button varButton = this.toolkit.createButton(composite, "Set", 8);
        varButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AssignFieldVariableDialog.this.con.setFieldBinding(variableText.getText());
                AssignFieldVariableDialog.this.modeller.reloadLhs();
                AssignFieldVariableDialog.this.modeller.setDirty(true);
                AssignFieldVariableDialog.this.close();
            }
        });
    }
}

