/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.DroolsEditorType;
import org.drools.lang.DroolsSentence;
import org.drools.lang.DroolsToken;
import org.drools.lang.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionContext {
    static final Pattern MVEL_DIALECT_PATTERN = Pattern.compile(".*dialect\\s+\"mvel\".*", 32);
    static final Pattern JAVA_DIALECT_PATTERN = Pattern.compile(".*dialect\\s+\"java\".*", 32);
    static final String MVEL_DIALECT = "mvel";
    static final String JAVA_DIALECT = "java";
    private LinkedList<Object> parserList;
    private int location;
    private int locationIndex;
    private String dialect;

    public CompletionContext(String backText) {
        DRLParser parser = this.getParser(backText);
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {}
        this.parserList = ((DroolsSentence)parser.getEditorInterface().get(0)).getContent();
        this.deriveLocation();
        this.determineDialect(backText);
    }

    public boolean isJavaDialect() {
        return JAVA_DIALECT.equalsIgnoreCase(this.dialect);
    }

    public boolean isMvelDialect() {
        return MVEL_DIALECT.equalsIgnoreCase(this.dialect);
    }

    public boolean isDefaultDialect() {
        return !this.isJavaDialect() && !this.isMvelDialect();
    }

    private void determineDialect(String backText) {
        this.dialect = null;
        boolean mvel = MVEL_DIALECT_PATTERN.matcher(backText).matches();
        boolean java = JAVA_DIALECT_PATTERN.matcher(backText).matches();
        if (mvel) {
            this.dialect = MVEL_DIALECT;
        } else if (java) {
            this.dialect = JAVA_DIALECT;
        }
    }

    public Location getLocation() {
        Location location = new Location(this.location);
        switch (this.location) {
            case 100: {
                Object o;
                int index = this.findToken("(", 100, this.locationIndex);
                if (index != -1 && (o = this.parserList.get(index - 1)) instanceof DroolsToken) {
                    String className = ((DroolsToken)o).getText();
                    location.setProperty("ClassName", (Object)className);
                }
                String propertyName = null;
                if (this.locationIndex + 1 < this.parserList.size()) {
                    propertyName = "";
                }
                int i = this.locationIndex + 1;
                while (i < this.parserList.size()) {
                    Object o2;
                    if (!((o2 = this.parserList.get(i++)) instanceof DroolsToken)) continue;
                    propertyName = String.valueOf(propertyName) + ((DroolsToken)o2).getText();
                }
                location.setProperty("PropertyName", (Object)propertyName);
                break;
            }
            case 101: {
                Object o;
                int index = this.findToken("(", 100, this.locationIndex);
                if (index != -1 && (o = this.parserList.get(index - 1)) instanceof DroolsToken) {
                    String className = ((DroolsToken)o).getText();
                    location.setProperty("ClassName", (Object)className);
                }
                String propertyName = null;
                index = this.findTokenBack(100, this.locationIndex);
                if (index == -1) break;
                if (index + 1 < this.locationIndex) {
                    propertyName = "";
                }
                int i = index + 1;
                while (i < this.locationIndex) {
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) break;
                    String token = ((DroolsToken)o).getText();
                    propertyName = ":".equals(token) ? "" : String.valueOf(propertyName) + token;
                }
                location.setProperty("PropertyName", (Object)propertyName);
                break;
            }
            case 102: {
                Object o;
                Object o3;
                int index1 = this.findToken("(", 100, this.locationIndex);
                int index2 = this.findTokenBack(101, this.locationIndex);
                int index3 = this.findTokenBack(100, this.locationIndex);
                int index4 = this.findTokenBack(102, this.locationIndex);
                if (index1 != -1 && index2 != -1 && (o3 = this.parserList.get(index1 - 1)) instanceof DroolsToken) {
                    String className = ((DroolsToken)o3).getText();
                    location.setProperty("ClassName", (Object)className);
                }
                String operator = "";
                int i = index2 + 1;
                while (i < this.locationIndex) {
                    o = this.parserList.get(i);
                    if (o instanceof DroolsToken) {
                        operator = String.valueOf(operator) + ((DroolsToken)o).getText();
                    }
                    if (index4 != -1 && i >= index4) break;
                    if (i < this.locationIndex - 1) {
                        operator = String.valueOf(operator) + " ";
                    }
                    ++i;
                }
                location.setProperty("Operator", (Object)operator.trim());
                String propertyName = null;
                if (index1 == -1) break;
                if (index3 + 1 < this.locationIndex - 1) {
                    propertyName = "";
                }
                i = index3 + 1;
                while (i < this.locationIndex - 1) {
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) break;
                    String token = ((DroolsToken)o).getText();
                    propertyName = ":".equals(token) ? "" : String.valueOf(propertyName) + token;
                }
                location.setProperty("PropertyName", (Object)propertyName);
                break;
            }
            case 103: {
                Object o;
                int index = this.findToken("(", 100, this.locationIndex);
                if (index == -1 || !((o = this.parserList.get(index - 1)) instanceof DroolsToken)) break;
                String className = ((DroolsToken)o).getText();
                location.setProperty("ClassName", (Object)className);
                break;
            }
            case 200: {
                String eval = "";
                int i = this.locationIndex + 1;
                while (i < this.parserList.size()) {
                    Object o;
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) continue;
                    eval = String.valueOf(eval) + ((DroolsToken)o).getText();
                }
                location.setProperty("EvalContent", (Object)eval.trim());
                break;
            }
            case 300: {
                String from = null;
                if (this.locationIndex + 1 < this.parserList.size()) {
                    from = "";
                }
                int i = this.locationIndex + 1;
                while (i < this.parserList.size()) {
                    Object o;
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) continue;
                    from = String.valueOf(from) + ((DroolsToken)o).getText();
                }
                location.setProperty("FromContent", (Object)from);
                break;
            }
            case 304: {
                String from = "";
                int i = this.locationIndex + 1;
                while (i < this.parserList.size()) {
                    Object o;
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) continue;
                    from = String.valueOf(from) + ((DroolsToken)o).getText();
                }
                location.setProperty("FromAccumulateInitContent", (Object)from);
                break;
            }
            case 306: {
                Object o;
                int i;
                String from = "";
                int index = this.findTokenBack(304, this.locationIndex);
                int index2 = this.findTokenBack(305, this.locationIndex);
                if (index != -1 && index2 != -1) {
                    i = index + 1;
                    while (i < index2 - 3) {
                        o = this.parserList.get(i);
                        if (o instanceof DroolsToken) {
                            from = String.valueOf(from) + ((DroolsToken)o).getText();
                        }
                        ++i;
                    }
                    location.setProperty("FromAccumulateInitContent", (Object)from.trim());
                }
                from = "";
                i = this.locationIndex + 1;
                while (i < this.parserList.size()) {
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) continue;
                    from = String.valueOf(from) + ((DroolsToken)o).getText();
                }
                location.setProperty("FromAccumulateActionContent", (Object)from);
                break;
            }
            case 310: {
                Object o;
                int i;
                String from = "";
                int index = this.findTokenBack(304, this.locationIndex);
                int index2 = this.findTokenBack(305, this.locationIndex);
                int index3 = this.findTokenBack(306, this.locationIndex);
                int index4 = this.findTokenBack(309, this.locationIndex);
                if (index != -1 && index2 != -1) {
                    i = index + 1;
                    while (i < index2 - 3) {
                        o = this.parserList.get(i);
                        if (o instanceof DroolsToken) {
                            from = String.valueOf(from) + ((DroolsToken)o).getText();
                        }
                        ++i;
                    }
                    location.setProperty("FromAccumulateInitContent", (Object)from.trim());
                }
                from = "";
                if (index3 != -1 && index4 != -1) {
                    i = index3 + 1;
                    while (i < index4 - 3) {
                        o = this.parserList.get(i);
                        if (o instanceof DroolsToken) {
                            from = String.valueOf(from) + ((DroolsToken)o).getText();
                        }
                        ++i;
                    }
                    location.setProperty("FromAccumulateActionContent", (Object)from);
                }
                from = "";
                i = this.locationIndex + 1;
                while (i < this.parserList.size()) {
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) continue;
                    from = String.valueOf(from) + ((DroolsToken)o).getText();
                }
                location.setProperty("FromAccumulateResultContent", (Object)from);
                break;
            }
            case 1000: {
                String rhs = "";
                int i = this.locationIndex + 1;
                int endLocationOfLast = 0x7FFFFFFE;
                while (i < this.parserList.size()) {
                    Object o;
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) continue;
                    DroolsToken token = (DroolsToken)o;
                    if (endLocationOfLast + 1 < token.getStartIndex()) {
                        rhs = String.valueOf(rhs) + " ";
                    }
                    rhs = String.valueOf(rhs) + token.getText();
                    endLocationOfLast = token.getStopIndex();
                }
                location.setProperty("RHSContent", (Object)rhs);
                break;
            }
            case 2000: {
                String header = "";
                int i = this.locationIndex + 1;
                while (i < this.parserList.size()) {
                    Object o;
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) continue;
                    header = String.valueOf(header) + ((DroolsToken)o).getText();
                }
                location.setProperty("HeaderContent", (Object)header);
                break;
            }
            case 2001: {
                Object o;
                int i;
                String header = "";
                int index = this.findTokenBack(2000, this.locationIndex);
                if (index != -1) {
                    i = index + 1;
                    while (i < this.locationIndex) {
                        o = this.parserList.get(i);
                        if (o instanceof DroolsToken) {
                            header = String.valueOf(header) + ((DroolsToken)o).getText();
                        }
                        ++i;
                    }
                }
                i = this.locationIndex + 1;
                while (i < this.parserList.size()) {
                    if (!((o = this.parserList.get(i++)) instanceof DroolsToken)) continue;
                    header = String.valueOf(header) + ((DroolsToken)o).getText();
                }
                location.setProperty("HeaderContent", (Object)header.trim());
            }
        }
        return location;
    }

    public String getRuleName() {
        Object o;
        if (this.parserList.size() >= 2 && (o = this.parserList.get(1)) instanceof DroolsToken) {
            String name = ((DroolsToken)o).getText();
            if (name.startsWith("\"") && name.endsWith("\"")) {
                name = name.substring(1, name.length() - 1);
            }
            return name;
        }
        return null;
    }

    public Map<String, String[]> getRuleParameters() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        int i = 0;
        int lastLocation = -1;
        for (Object e : this.parserList) {
            if (e instanceof DroolsToken) {
                DroolsToken token = (DroolsToken)e;
                if (DroolsEditorType.IDENTIFIER_VARIABLE.equals((Object)token.getEditorType()) || DroolsEditorType.IDENTIFIER_PATTERN.equals((Object)token.getEditorType())) {
                    String variableName = token.getText();
                    if (lastLocation == 1) {
                        int j = i + 2;
                        String className = "";
                        while (j < this.parserList.size()) {
                            Object obj;
                            if (!((obj = this.parserList.get(j++)) instanceof DroolsToken)) continue;
                            String s = ((DroolsToken)obj).getText();
                            if ("(".equals(s)) {
                                String[] stringArray = new String[2];
                                stringArray[0] = className;
                                result.put(variableName, stringArray);
                                break;
                            }
                            className = String.valueOf(className) + s;
                        }
                    } else if (lastLocation == 100) {
                        int index = this.findTokenBack(1, i);
                        int j = index + 3;
                        String className = "";
                        while (j < i) {
                            Object obj;
                            if (!((obj = this.parserList.get(j++)) instanceof DroolsToken)) continue;
                            String s = ((DroolsToken)obj).getText();
                            if ("(".equals(s)) break;
                            className = String.valueOf(className) + s;
                        }
                        j = i + 2;
                        String propertyName = "";
                        while (j < this.parserList.size()) {
                            Object obj;
                            if ((obj = this.parserList.get(j++)) instanceof DroolsToken) {
                                String s = ((DroolsToken)obj).getText();
                                if (",".equals(s) || ")".equals(s)) {
                                    result.put(variableName, new String[]{className, propertyName});
                                    break;
                                }
                                propertyName = String.valueOf(propertyName) + s;
                                continue;
                            }
                            result.put(variableName, new String[]{className, propertyName});
                        }
                    }
                }
            } else if (e instanceof Integer) {
                lastLocation = (Integer)e;
            }
            ++i;
        }
        return result;
    }

    private int findToken(String token, int integer, int location) {
        int index = location - 1;
        while (index >= 0) {
            Object o = this.parserList.get(index);
            if (o instanceof DroolsToken && "(".equals(((DroolsToken)o).getText()) && this.getNextInteger(index) == integer) {
                return index;
            }
            --index;
        }
        return -1;
    }

    private int findTokenBack(int token, int location) {
        int index = location - 1;
        while (index >= 0) {
            Object o = this.parserList.get(index);
            if (o instanceof Integer && token == (Integer)o) {
                return index;
            }
            --index;
        }
        return -1;
    }

    private int getNextInteger(int location) {
        int index = location;
        while (index >= 0) {
            Object o = this.parserList.get(index);
            if (o instanceof Integer) {
                return (Integer)o;
            }
            ++index;
        }
        return -1;
    }

    private void deriveLocation() {
        this.location = -1;
        int i = 0;
        for (Object e : this.parserList) {
            if (e instanceof Integer) {
                this.location = (Integer)e;
                this.locationIndex = i;
            }
            ++i;
        }
    }

    private DRLParser getParser(String text) {
        DRLParser parser = new DRLParser((TokenStream)new CommonTokenStream((TokenSource)new DRLLexer((CharStream)new ANTLRStringStream(text))));
        parser.enableEditorInterface();
        return parser;
    }
}

