/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.guvnor.tools.GuvnorLocationManager;
import org.guvnor.tools.Messages;
import org.guvnor.tools.ResourceChangeListener;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.drools.guvnor";
    private static Activator plugin;
    private static GuvnorLocationManager locManager;
    private ResourceChangeListener rcListner = new ResourceChangeListener();
    private static ImageDescriptor GUVCONTROLLED_IMG;
    private static ImageDescriptor GUVLOCADD_IMG;
    private static ImageDescriptor GUVREPWIZBAN_IMG;
    public static final String IMG_GUVCONTROLLED = "guvnor_controlled.gif";
    public static final String IMG_GUVLOCADD = "guvnor_rep_add.gif";
    public static final String IMG_GUVREPWIZBAN = "guvnor_rep_wizban.gif";

    public static GuvnorLocationManager getLocationManager() {
        if (locManager == null) {
            locManager = new GuvnorLocationManager();
        }
        return locManager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.rcListner);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.rcListner);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private IStatus createStatus(int severity, String msg, Throwable t) {
        return new Status(severity, PLUGIN_ID, msg, t);
    }

    public void writeLog(int severity, String msg, Throwable t) {
        super.getLog().log(this.createStatus(severity, msg, t));
    }

    public void writeLog(IStatus status) {
        super.getLog().log(status);
    }

    public void displayMessage(final int severity, final String msg) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                switch (severity) {
                    case 4: {
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.getString("error"), (String)msg);
                        break;
                    }
                    case 2: {
                        MessageDialog.openWarning((Shell)display.getActiveShell(), (String)Messages.getString("warning"), (String)msg);
                    }
                }
            }
        });
    }

    public void displayError(int severity, String msg, Throwable t, boolean shouldLog) {
        final IStatus status = this.createStatus(severity, msg, t);
        if (shouldLog) {
            this.writeLog(status);
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)display.getActiveShell(), null, (String)Messages.getString("error"), (IStatus)status);
            }
        });
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        ImageDescriptor img = Activator.getCachedImageDescriptor(id);
        if (img == null) {
            img = Activator.loadImageDescriptor(id);
        }
        return img;
    }

    private static ImageDescriptor loadImageDescriptor(String id) {
        String iconPath = "icons/";
        try {
            URL installURL = Activator.getDefault().getBundle().getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + id);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor getCachedImageDescriptor(String id) {
        ImageDescriptor img = null;
        if (id.equals(IMG_GUVCONTROLLED)) {
            if (GUVCONTROLLED_IMG == null) {
                GUVCONTROLLED_IMG = Activator.loadImageDescriptor(IMG_GUVCONTROLLED);
            }
            img = GUVCONTROLLED_IMG;
        }
        if (id.equals(IMG_GUVLOCADD)) {
            if (GUVLOCADD_IMG == null) {
                GUVLOCADD_IMG = Activator.loadImageDescriptor(IMG_GUVLOCADD);
            }
            img = GUVLOCADD_IMG;
        }
        if (id.equals(IMG_GUVREPWIZBAN)) {
            if (GUVREPWIZBAN_IMG == null) {
                GUVREPWIZBAN_IMG = Activator.loadImageDescriptor(IMG_GUVREPWIZBAN);
            }
            img = GUVREPWIZBAN_IMG;
        }
        return img;
    }

    public boolean useDebugHttpClient() {
        return Boolean.parseBoolean(Platform.getDebugOption((String)"org.guvnor.tools/debugHttpClient"));
    }
}

