/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Element;

public class LockEntry
extends ElementEditor {
    protected static final String[] childNames = new String[]{"lockscope", "locktype"};

    public LockEntry(Element root) throws MalformedElementException {
        super(root, "lockentry");
    }

    public boolean isShared() throws MalformedElementException {
        Element lockscope = ElementEditor.getFirstChild(this.root, "lockscope");
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingLockscopeElmt"), lockscope);
        String[] names = new String[]{"shared", "exclusive"};
        Element sharedOrExclusive = ElementEditor.getFirstChild(lockscope, names);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingSharedOrExclusiveElmt"), sharedOrExclusive);
        boolean isShared = ElementEditor.isDAVElement(sharedOrExclusive, "shared");
        ElementEditor.ensure(ElementEditor.getNextSibling(sharedOrExclusive, names) == null, Policy.bind("ensure.conflictingSharedOrExclusiveElmt"));
        return isShared;
    }

    public void setIsShared(boolean isShared) {
        Element lockscope = ElementEditor.setChild(this.root, "lockscope", childNames, true);
        if (isShared) {
            ElementEditor.appendChild(lockscope, "shared");
        } else {
            ElementEditor.appendChild(lockscope, "exclusive");
        }
    }
}

