/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Owner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockInfo
extends ElementEditor {
    public static final String[] childNames = new String[]{"lockscope", "locktype", "owner"};

    public LockInfo(Element root) throws MalformedElementException {
        super(root, "lockinfo");
    }

    public static LockInfo create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Element element = ElementEditor.create(document, "lockinfo");
        Element locktype = ElementEditor.appendChild(element, "locktype");
        ElementEditor.appendChild(locktype, "write");
        LockInfo result = null;
        try {
            result = new LockInfo(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public Owner getOwner() throws MalformedElementException {
        Element owner = ElementEditor.getLastChild(this.root, "owner");
        if (owner == null) {
            return null;
        }
        return new Owner(owner);
    }

    public boolean isShared() throws MalformedElementException {
        Element lockscope = ElementEditor.getFirstChild(this.root, "lockscope");
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingLockscopeElmt"), lockscope);
        String[] names = new String[]{"shared", "exclusive"};
        Element sharedOrExclusive = ElementEditor.getFirstChild(lockscope, names);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingSharedOrExclusiveElmt"), sharedOrExclusive);
        boolean isShared = ElementEditor.isDAVElement(sharedOrExclusive, "shared");
        ElementEditor.ensure(ElementEditor.getNextSibling(sharedOrExclusive, names) == null, Policy.bind("ensure.conflictingSharedOrExclusiveElmt"));
        return isShared;
    }

    public void setIsShared(boolean isShared) {
        Element lockscope = ElementEditor.setChild(this.root, "lockscope", childNames, true);
        if (isShared) {
            ElementEditor.appendChild(lockscope, "shared");
        } else {
            ElementEditor.appendChild(lockscope, "exclusive");
        }
    }

    public Owner setOwner() {
        Element owner = ElementEditor.setChild(this.root, "owner", childNames, false);
        Owner result = null;
        try {
            result = new Owner(owner);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }
}

