/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.ValueEditorTypeSelectionDialog;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ConstraintValueEditor {
    private Composite composite;
    private BaseSingleFieldConstraint constraint;
    private FormToolkit toolkit;
    private RuleModeller modeller;
    private boolean numericValue;
    private FactPattern pattern;

    public ConstraintValueEditor(Composite composite, BaseSingleFieldConstraint constraint, FormToolkit toolkit, RuleModeller modeller, String numericType) {
        this(composite, constraint, toolkit, modeller, numericType, null);
    }

    public ConstraintValueEditor(Composite parent, BaseSingleFieldConstraint c, FormToolkit toolkit, RuleModeller modeller, String type, FactPattern pattern) {
        this.pattern = pattern;
        this.composite = parent;
        this.constraint = c;
        this.toolkit = toolkit;
        this.modeller = modeller;
        if ("Numeric".equals(type)) {
            this.numericValue = true;
        }
        this.create();
    }

    private void create() {
        if (this.constraint.getConstraintValueType() == 0) {
            ImageHyperlink link = this.addImage(this.composite, "icons/edit.gif");
            link.setToolTipText("Choose value editor type");
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    ValueEditorTypeSelectionDialog popup = new ValueEditorTypeSelectionDialog(ConstraintValueEditor.this.composite.getShell(), ConstraintValueEditor.this.toolkit, ConstraintValueEditor.this.modeller, ConstraintValueEditor.this.constraint);
                    popup.open();
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }
            });
            GridData gd = new GridData(800);
            gd.horizontalSpan = 2;
            link.setLayoutData((Object)gd);
        } else {
            switch (this.constraint.getConstraintValueType()) {
                case 1: {
                    this.literalValueEditor(this.composite, this.constraint, new GridData(768));
                    break;
                }
                case 3: {
                    this.addImage(this.composite, "icons/function_assets.gif");
                    this.formulaValueEditor(this.composite, this.constraint, new GridData(768));
                    break;
                }
                case 2: {
                    this.variableEditor(this.composite, this.constraint, new GridData(768));
                    break;
                }
            }
        }
    }

    private void literalValueEditor(Composite parent, final BaseSingleFieldConstraint c, GridData gd) {
        String fieldName = null;
        if (c instanceof SingleFieldConstraint) {
            fieldName = ((SingleFieldConstraint)c).getFieldName();
        } else if (c instanceof ConnectiveConstraint) {
            fieldName = ((ConnectiveConstraint)c).getFieldName();
        }
        String fieldType = null;
        if (c instanceof SingleFieldConstraint) {
            fieldType = ((SingleFieldConstraint)c).getFieldType();
        } else if (c instanceof ConnectiveConstraint) {
            fieldType = ((ConnectiveConstraint)c).getFieldType();
        }
        DropDownData enums = null;
        boolean found = false;
        enums = fieldType.equals("Boolean") ? DropDownData.create((String[])new String[]{"true", "false"}) : this.modeller.getSuggestionCompletionEngine().getEnums(this.pattern, fieldName);
        if (enums != null && enums.fixedList.length > 0) {
            String[] list = enums.fixedList;
            final Combo combo = new Combo(parent, 12);
            int i = 0;
            while (i < list.length) {
                String e = list[i];
                String[] split = null;
                boolean s = false;
                if (e.indexOf(61) > 0) {
                    split = e.split("=");
                    e = split[1];
                    combo.add(e.trim());
                    combo.setData(e.trim(), (Object)split[0].trim());
                    s = true;
                } else {
                    combo.add(e);
                }
                if (e.equals(c.getValue()) || s && split[0].trim().equals(c.getValue())) {
                    combo.select(i);
                    found = true;
                }
                ++i;
            }
            if (!found && c.getValue() != null) {
                combo.add(c.getValue());
                combo.select(combo.getItemCount() - 1);
            }
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String item = combo.getItem(combo.getSelectionIndex());
                    if (combo.getData(item) != null) {
                        item = (String)combo.getData(item);
                    }
                    c.setValue(item);
                    ConstraintValueEditor.this.modeller.reloadLhs();
                    ConstraintValueEditor.this.modeller.setDirty(true);
                }
            });
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            gd.minimumWidth = 100;
            combo.setLayoutData((Object)gd);
        } else {
            final Text box = this.toolkit.createText(parent, "");
            if (c.getValue() != null) {
                box.setText(c.getValue());
            }
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            gd.minimumWidth = 100;
            box.setLayoutData((Object)gd);
            box.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    c.setValue(box.getText());
                    ConstraintValueEditor.this.modeller.setDirty(true);
                }
            });
            if (this.numericValue) {
                box.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (Character.isLetter(e.character)) {
                            e.doit = false;
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
            }
        }
    }

    private void formulaValueEditor(Composite parent, final BaseSingleFieldConstraint c, GridData gd) {
        final Text box = this.toolkit.createText(parent, "");
        if (c.getValue() != null) {
            box.setText(c.getValue());
        }
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        box.setLayoutData((Object)gd);
        box.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                c.setValue(box.getText());
                ConstraintValueEditor.this.modeller.setDirty(true);
            }
        });
    }

    private void variableEditor(Composite composite, final BaseSingleFieldConstraint c, GridData gd) {
        List vars = this.modeller.getModel().getBoundVariablesInScope(c);
        final Combo combo = new Combo(composite, 8);
        gd.horizontalSpan = 2;
        combo.setLayoutData((Object)gd);
        if (c.getValue() == null) {
            combo.add("Choose ...");
        }
        int idx = 0;
        int i = 0;
        while (i < vars.size()) {
            String var = (String)vars.get(i);
            if (c.getValue() != null && c.getValue().equals(var)) {
                idx = i;
            }
            combo.add(var);
            ++i;
        }
        combo.select(idx);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                c.setValue(combo.getText());
            }
        });
    }

    public ImageHyperlink addImage(Composite parent, String fileName) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(parent, 0);
        ImageDescriptor imageDescriptor = DroolsEclipsePlugin.getImageDescriptor(fileName);
        imageHyperlink.setImage(imageDescriptor.createImage());
        return imageHyperlink;
    }
}

