/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.views.RepositoryContentProvider;
import org.guvnor.tools.views.RepositoryLabelProvider;
import org.guvnor.tools.views.model.TreeObject;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.IGuvnorWizard;
import org.guvnor.tools.wizards.WizardUtils;

public class SelectGuvnorResourcesPage
extends WizardPage {
    private TreeViewer viewer;
    private String previousSelection;
    private Action doubleClickAction;

    public SelectGuvnorResourcesPage(String pageName) {
        super(pageName);
    }

    public SelectGuvnorResourcesPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = PlatformUtils.createComposite(parent, 1);
        new Label(composite, 0).setText(Messages.getString("select.resources"));
        this.viewer = new TreeViewer(composite, 2818);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectGuvnorResourcesPage.this.updateModel();
            }
        });
        this.hookDoubleClickAction();
        super.setControl((Control)composite);
    }

    private void hookDoubleClickAction() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = SelectGuvnorResourcesPage.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof TreeObject) {
                    SelectGuvnorResourcesPage.this.doubleClick((TreeObject)obj);
                }
            }
        };
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectGuvnorResourcesPage.this.doubleClickAction.run();
            }
        });
    }

    private void doubleClick(TreeObject node) {
        if (node.getNodeType() == TreeObject.Type.PACKAGE || node.getNodeType() == TreeObject.Type.REPOSITORY) {
            if (this.viewer.getExpandedState((Object)node)) {
                this.viewer.collapseToLevel((Object)node, 1);
            } else {
                this.viewer.expandToLevel((Object)node, 1);
            }
        }
    }

    private void handleRepositoryCreation() {
        GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
        if (model.shouldCreateNewRep() && model.getRepLocation() != null) {
            GuvnorRepository theRep = Activator.getLocationManager().findRepository(model.getRepLocation());
            if (theRep != null) {
                return;
            }
            try {
                WizardUtils.createGuvnorRepository(model);
            }
            catch (Exception e) {
                super.setErrorMessage(e.getMessage());
                Activator.getDefault().displayError(4, e.getMessage(), e, true);
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
            String currentSelection = model.getRepLocation();
            assert (currentSelection != null);
            if (this.previousSelection != null && !currentSelection.equals(this.previousSelection)) {
                this.handleRepositoryCreation();
                RepositoryContentProvider cp = new RepositoryContentProvider();
                cp.setRepositorySelection(currentSelection);
                this.viewer.setContentProvider((IContentProvider)cp);
                this.viewer.setInput((Object)this.viewer);
                this.previousSelection = currentSelection;
            } else if (this.previousSelection == null) {
                this.handleRepositoryCreation();
                RepositoryContentProvider cp = new RepositoryContentProvider();
                cp.setRepositorySelection(currentSelection);
                this.viewer.setContentProvider((IContentProvider)cp);
                this.viewer.setInput((Object)this.viewer);
                this.previousSelection = currentSelection;
            }
        }
        super.setVisible(visible);
    }

    private void updateModel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            ArrayList<String> resources = new ArrayList<String>();
            List nodes = selection.toList();
            for (TreeObject o : nodes) {
                if (o.getNodeType() != TreeObject.Type.RESOURCE) continue;
                resources.add(o.getFullPath());
            }
            GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
            if (resources.size() > 0) {
                model.setResources(resources);
            } else {
                model.setResources(null);
            }
        }
        super.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
        return model.getResources() != null && model.getResources().size() > 0;
    }
}

