/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.task.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jbpm.eclipse.task.Activator;

public class TaskPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text ipAddressText;
    private Text portText;
    private Text languageText;

    protected Control createContents(Composite parent) {
        this.ipAddressText = this.createText(parent, "IP address");
        this.portText = this.createText(parent, "Port");
        this.languageText = this.createText(parent, "Language");
        this.initializeValues();
        return new Composite(parent, 0);
    }

    private Text createText(Composite group, String labelText) {
        Label label = new Label(group, 0);
        label.setText(labelText);
        Text text = new Text(group, 0);
        return text;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.ipAddressText.setText(store.getDefaultString("ServerIPAddress"));
        this.portText.setText(String.valueOf(store.getDefaultInt("ServerPort")));
        this.languageText.setText(store.getDefaultString("Language"));
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.ipAddressText.setText(store.getString("ServerIPAddress"));
        this.portText.setText(String.valueOf(store.getInt("ServerPort")));
        this.languageText.setText(store.getString("Language"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        Activator.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        try {
            Integer port = new Integer(this.portText.getText());
            IPreferenceStore store = this.getPreferenceStore();
            store.setValue("ServerIPAddress", this.ipAddressText.getText());
            store.setValue("ServerPort", port.intValue());
            store.setValue("Language", this.languageText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.showMessage("Could not convert port, should be an integer value.");
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)"Task View", (String)message);
    }
}

