/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Update
extends ElementEditor {
    public static String[] childNames = new String[]{"label-name", "version"};

    public Update(Element root) throws MalformedElementException {
        super(root, "set-target");
    }

    public static Update createLabel(Document document, String label) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Assert.isNotNull(label);
        Element element = ElementEditor.create(document, "update");
        try {
            Update editor = new Update(element);
            editor.setLabelName(label);
            return editor;
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public static Update createVersion(Document document, String href) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Assert.isNotNull(href);
        Element element = ElementEditor.create(document, "update");
        try {
            Update editor = new Update(element);
            editor.setVersion(href);
            return editor;
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public String getLabel() throws MalformedElementException {
        String label = ElementEditor.getChildText(this.root, "label", true);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingLabelElmt"), label);
        return label;
    }

    public String getVersion() throws MalformedElementException {
        Element version = ElementEditor.getFirstChild(this.root, "version");
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingVersionElmt"), version);
        String href = ElementEditor.getChildText(version, "href", true);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), href);
        return ElementEditor.decodeHref(href);
    }

    public boolean isVersion() throws MalformedElementException {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingTargetDesc"), child);
        return ElementEditor.getNSLocalName(child).equals("version");
    }

    public void setLabelName(String label) throws MalformedElementException {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        if (ElementEditor.isDAVElement(child, "version")) {
            this.root.removeChild(child);
        }
        ElementEditor.setChild(child, "label-name", label, new String[]{"label-name"}, true);
    }

    public void setVersion(String href) throws MalformedElementException {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        if (ElementEditor.isDAVElement(child, "label-name")) {
            this.root.removeChild(child);
        }
        Element newChild = ElementEditor.setChild(this.root, "version", new String[]{"version"}, true);
        ElementEditor.setChild(newChild, "href", ElementEditor.encodeHref(href), new String[]{"href"}, true);
    }
}

