/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.webdav.client.URLTool;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class URLTable {
    private Hashtable table;

    public URLTable() {
        this.table = new Hashtable();
    }

    public URLTable(int size) {
        this.table = new Hashtable(size);
    }

    public Object get(String url) throws MalformedURLException {
        Assert.isNotNull(url);
        return this.get(new URL(url));
    }

    public Object get(URL url) {
        Assert.isNotNull(url);
        return this.get(new URLKey(url));
    }

    private Object get(URLKey url) {
        Assert.isNotNull(url);
        return this.table.get(url);
    }

    public Enumeration keys() {
        final Enumeration keys = this.table.keys();
        Enumeration e = new Enumeration(){

            public boolean hasMoreElements() {
                return keys.hasMoreElements();
            }

            public Object nextElement() {
                return ((URLKey)keys.nextElement()).getURL();
            }
        };
        return e;
    }

    public void put(String url, Object value) throws MalformedURLException {
        Assert.isNotNull(url);
        Assert.isNotNull(value);
        this.put(new URL(url), value);
    }

    public void put(URL url, Object value) {
        Assert.isNotNull(url);
        Assert.isNotNull(value);
        this.put(new URLKey(url), value);
    }

    private void put(URLKey url, Object value) {
        Assert.isNotNull(url);
        Assert.isNotNull(value);
        if (this.table.get(url) != null) {
            this.table.remove(url);
        }
        this.table.put(url, value);
    }

    public void remove(String url) throws MalformedURLException {
        Assert.isNotNull(url);
        this.remove(new URL(url));
    }

    public void remove(URL url) {
        Assert.isNotNull(url);
        this.remove(new URLKey(url));
    }

    private void remove(URLKey url) {
        Assert.isNotNull(url);
        this.table.remove(url);
    }

    class URLKey {
        URL url;
        int hashCode = -1;

        public URLKey(URL url) {
            this.url = url;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof URLKey) {
                return this.equals(((URLKey)obj).getURL());
            }
            if (obj instanceof String) {
                try {
                    return this.equals(new URL((String)obj));
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }
            if (!(obj instanceof URL)) {
                return false;
            }
            if (this.url == (URL)obj) {
                return true;
            }
            URL url1 = URLTool.removeTrailingSlash(this.url);
            URL url2 = URLTool.removeTrailingSlash((URL)obj);
            return url1.equals(url2);
        }

        public URL getURL() {
            return this.url;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = URLTool.removeTrailingSlash(this.url).hashCode();
            }
            return this.hashCode;
        }

        public String toString() {
            return this.url.toString();
        }
    }
}

