/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.WebDAVFactory;
import org.eclipse.webdav.http.client.HttpConnection;
import org.eclipse.webdav.http.client.IAuthenticator;
import org.eclipse.webdav.http.client.ISocketFactory;
import org.eclipse.webdav.http.client.IStatusCodes;
import org.eclipse.webdav.http.client.Message;
import org.eclipse.webdav.http.client.Request;
import org.eclipse.webdav.http.client.Response;
import org.eclipse.webdav.internal.authentication.AuthorizationAuthority;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class HttpClient
implements IStatusCodes {
    private double httpVersion = 1.1;
    private boolean closed = true;
    private ConnectionsRecycler connectionsRecycler = new ConnectionsRecycler("Connections Recycler");
    private AuthorizationAuthority authority = null;
    private Hashtable contexts = new Hashtable(5);
    private IContext defaultContext = null;
    private URL defaultProxyServerUrl = null;
    private Hashtable proxyServerUrls = new Hashtable(5);
    private Hashtable proxyServerExceptions = new Hashtable(5);
    private int maxRetries = 1;
    private int maxRedirects = 4;
    private int socketTimeout = 0;
    private ISocketFactory socketFactory = null;
    private WebDAVFactory webDAVFactory = new WebDAVFactory();

    public HttpClient() {
        this.open();
    }

    public void addProxyServerException(String pattern) {
        Assert.isNotNull(pattern);
        this.proxyServerExceptions.put(pattern, pattern);
    }

    public void close() {
        if (!this.closed) {
            this.connectionsRecycler.close();
            this.closed = true;
        }
    }

    public long getConnectionTimeout() {
        return this.connectionsRecycler.getConnectionTimeout();
    }

    public IContext getContext(URL originServerUrl) {
        Assert.isNotNull(originServerUrl);
        return (IContext)this.contexts.get(originServerUrl);
    }

    public IContext getDefaultContext() {
        return this.defaultContext;
    }

    public URL getDefaultProxyServerUrl() {
        return this.defaultProxyServerUrl;
    }

    public double getHttpVersion() {
        return this.httpVersion;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Enumeration getOriginServerUrls() {
        final Enumeration enum1 = this.contexts.keys();
        final Enumeration enum2 = this.proxyServerUrls.keys();
        Enumeration e = new Enumeration(){

            public boolean hasMoreElements() {
                return enum1.hasMoreElements() || enum2.hasMoreElements();
            }

            public Object nextElement() {
                if (enum1.hasMoreElements()) {
                    return enum1.nextElement();
                }
                return enum2.nextElement();
            }
        };
        return e;
    }

    public Enumeration getProxyServerExceptions() {
        return this.proxyServerExceptions.keys();
    }

    public URL getProxyServerUrl(URL originServerUrl) {
        Assert.isNotNull(originServerUrl);
        return (URL)this.proxyServerUrls.get(originServerUrl);
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public Response invoke(Request request) throws IOException {
        Assert.isNotNull(request);
        try {
            this.open();
            URL resourceUrl = request.getResourceUrl();
            URL originServerUrl = new URL(resourceUrl.getProtocol(), resourceUrl.getHost(), resourceUrl.getPort(), "/");
            URL proxyServerUrl = this.getProxyServerUrl(originServerUrl);
            if (proxyServerUrl == null && !this.matchesProxyServerException(originServerUrl)) {
                proxyServerUrl = this.getDefaultProxyServerUrl();
            }
            IContext context = this.webDAVFactory.newContext(request.getContext());
            IContext defaultContext = this.getContext(originServerUrl);
            if (defaultContext == null) {
                defaultContext = this.getDefaultContext();
            }
            if (defaultContext != null) {
                Enumeration e = defaultContext.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    context.put(key, defaultContext.get(key));
                }
            }
            if (this.authority != null) {
                this.authority.authorize(request, null, context, proxyServerUrl, true);
                this.authority.authorize(request, null, context, proxyServerUrl, false);
            }
            Response response = this.invoke1(request, context, proxyServerUrl, originServerUrl, 0, 0);
            return response;
        }
        finally {
            request.close();
        }
    }

    private Response invoke1(Request request, IContext context, URL proxyServerUrl, URL originServerUrl, int retries, int redirects) throws IOException {
        Message response = null;
        try {
            response = this.invoke2(request, context, proxyServerUrl, originServerUrl, false);
            int sc = ((Response)response).getStatusCode();
            if (sc == 401 || sc == 407) {
                if (this.authority == null || !this.authority.authorize(request, (IResponse)((Object)response), context, proxyServerUrl, sc == 407)) {
                    return response;
                }
                response.close();
                return this.invoke1(request, context, proxyServerUrl, originServerUrl, 0, 0);
            }
            if (sc >= 300 && sc < 400) {
                if (redirects >= this.maxRedirects) {
                    return response;
                }
                String location = response.getContext().getLocation();
                if (location == null) {
                    return response;
                }
                URL url = new URL(location);
                if (sc == 305) {
                    proxyServerUrl = url;
                } else {
                    originServerUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/");
                    request.setResourceUrl(url);
                }
                response.close();
                return this.invoke1(request, context, proxyServerUrl, originServerUrl, 0, redirects + 1);
            }
            if (this.authority != null) {
                this.authority.confirm(request, (IResponse)((Object)response), proxyServerUrl);
            }
            return response;
        }
        catch (IOException e) {
            if (response != null) {
                response.close();
            }
            if (retries < this.maxRetries) {
                return this.invoke1(request, context, proxyServerUrl, originServerUrl, retries + 1, 0);
            }
            throw e;
        }
    }

    private Response invoke2(Request request, IContext context, URL proxyServerUrl, URL originServerUrl, boolean expect100Continue) throws IOException {
        HttpConnection connection = null;
        try {
            connection = this.connectionsRecycler.getConnection(originServerUrl);
            connection.setHttpVersion(this.httpVersion);
            connection.setRequestMethod(request.getMethod());
            connection.setResourceUrl(request.getResourceUrl());
            connection.setProxyServerUrl(proxyServerUrl);
            connection.clearRequestHeader();
            Enumeration e = context.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                connection.setRequestHeaderField(key, context.get(key));
            }
            long contentLength = request.getContentLength();
            if (contentLength >= 0L && context.getContentLength() == -1L) {
                connection.setRequestHeaderField("Content-Length", "" + contentLength);
            }
            String method = request.getMethod();
            boolean sendChunked = contentLength == -1L && this.httpVersion > 0.0 && !method.equals("PROPPATCH") && !method.equals("PROPFIND");
            connection.setSendChunked(sendChunked);
            connection.setPersistent(this.httpVersion > 0.0);
            connection.setSoTimeout(this.socketTimeout);
            connection.setSocketFactory(this.socketFactory);
            IContext responseHeader = null;
            if (expect100Continue && (contentLength > 0L && this.httpVersion > 0.0 || sendChunked)) {
                if (!"100-continue".equalsIgnoreCase(context.get("Expect"))) {
                    connection.setRequestHeaderField("Expect", "100-continue");
                }
                responseHeader = this.readResponseHeader(connection);
                if (connection.getStatusCode() != 100) {
                    return new Response(connection.getStatusCode(), connection.getStatusMessage(), responseHeader, new PersistentInputStream(connection));
                }
            }
            if (contentLength != 0L) {
                OutputStream os = connection.getOutputStream();
                request.write(os);
                os.close();
            }
            responseHeader = this.readResponseHeader(connection);
            return new Response(connection.getStatusCode(), connection.getStatusMessage(), responseHeader, new PersistentInputStream(connection));
        }
        catch (IOException e1) {
            try {
                connection.close();
            }
            catch (IOException iOException) {}
            this.connectionsRecycler.putConnection(connection);
            throw e1;
        }
    }

    private boolean matchesProxyServerException(URL originServerUrl) {
        String host = originServerUrl.getHost();
        int port = originServerUrl.getPort();
        String originServerUrlString = String.valueOf(host) + (port == -1 ? "" : ":" + port);
        boolean found = false;
        Enumeration keys = this.proxyServerExceptions.keys();
        while (!found && keys.hasMoreElements()) {
            String httpProxyException = (String)keys.nextElement();
            int len = httpProxyException.length();
            found = originServerUrlString.equals(httpProxyException);
            if (found) continue;
            if (httpProxyException.startsWith("*")) {
                found = originServerUrlString.endsWith(httpProxyException.substring(1, len));
                continue;
            }
            if (!httpProxyException.endsWith("*")) continue;
            found = originServerUrlString.startsWith(httpProxyException.substring(0, len - 1));
        }
        return found;
    }

    private void open() {
        if (this.closed) {
            this.connectionsRecycler.start();
            this.closed = false;
        }
    }

    private IContext readResponseHeader(HttpConnection httpConnection) throws IOException {
        IContext responseHeader = this.webDAVFactory.newContext();
        int position = 0;
        String fieldName = null;
        while ((fieldName = httpConnection.getResponseHeaderFieldName(position)) != null) {
            if (responseHeader.get(fieldName.toLowerCase()) == null) {
                responseHeader.put(fieldName.toLowerCase(), httpConnection.getResponseHeaderFieldValue(position));
            }
            ++position;
        }
        return responseHeader;
    }

    public void removeProxyServerException(String pattern) {
        Assert.isNotNull(pattern);
        this.proxyServerExceptions.remove(pattern);
    }

    public void setAuthenticator(IAuthenticator authenticator) {
        this.authority = authenticator == null ? null : new AuthorizationAuthority(authenticator);
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionsRecycler.setConnectionTimeout(connectionTimeout);
    }

    public void setContext(URL originServerUrl, IContext context) {
        Assert.isNotNull(originServerUrl);
        if (context == null) {
            this.contexts.remove(originServerUrl);
        } else {
            this.contexts.put(originServerUrl, context);
        }
    }

    public void setDefaultContext(IContext context) {
        this.defaultContext = context;
    }

    public void setDefaultProxyServerUrl(URL proxyServerUrl) {
        this.defaultProxyServerUrl = proxyServerUrl;
    }

    public void setHttpVersion(double httpVersion) {
        Assert.isTrue(httpVersion == 1.0 || httpVersion == 1.1);
        this.httpVersion = httpVersion;
    }

    public void setMaxRedirects(int maxRedirects) {
        Assert.isTrue(maxRedirects >= 0);
        this.maxRedirects = maxRedirects;
    }

    public void setMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= 0);
        this.maxRetries = maxRetries;
    }

    public void setProxyServerUrl(URL originServerUrl, URL proxyServerUrl) {
        Assert.isNotNull(originServerUrl);
        if (proxyServerUrl == null) {
            this.proxyServerUrls.remove(originServerUrl);
        } else {
            this.proxyServerUrls.put(originServerUrl, proxyServerUrl);
        }
    }

    public void setSocketFactory(ISocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setSoTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public class ConnectionsRecycler
    extends Thread {
        private long connectionTimeout;
        private Hashtable unusedConnections;
        private Hashtable usedConnections;

        public ConnectionsRecycler(String name) {
            super(name);
            this.connectionTimeout = 10000L;
            this.unusedConnections = new Hashtable(5);
            this.usedConnections = new Hashtable(5);
            this.setDaemon(true);
        }

        public synchronized void close() {
            this.interrupt();
            this.closeConnections(this.unusedConnections);
            this.closeConnections(this.usedConnections);
        }

        private synchronized void closeConnections(Hashtable connections) {
            Enumeration originServerUrls = connections.keys();
            while (originServerUrls.hasMoreElements()) {
                URL originServerUrl = (URL)originServerUrls.nextElement();
                Vector connectionsVector = (Vector)connections.get(originServerUrl);
                Enumeration connectionsEnum = connectionsVector.elements();
                while (connectionsEnum.hasMoreElements()) {
                    HttpConnection connection = (HttpConnection)connectionsEnum.nextElement();
                    try {
                        connection.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            connections.clear();
        }

        public synchronized HttpConnection getConnection(URL originServerUrl) {
            HttpConnection connection = null;
            Vector unusedConnections = (Vector)this.unusedConnections.get(originServerUrl);
            if (unusedConnections == null || unusedConnections.isEmpty()) {
                connection = new HttpConnection(originServerUrl);
            } else {
                connection = (HttpConnection)unusedConnections.lastElement();
                unusedConnections.removeElementAt(unusedConnections.size() - 1);
            }
            Vector<HttpConnection> usedConnections = (Vector<HttpConnection>)this.usedConnections.get(originServerUrl);
            if (usedConnections == null) {
                usedConnections = new Vector<HttpConnection>(5);
                this.usedConnections.put(originServerUrl, usedConnections);
            }
            usedConnections.addElement(connection);
            connection.setTimestamp(new Date());
            return connection;
        }

        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public synchronized void putConnection(HttpConnection connection) {
            URL resourceUrl = connection.getResourceUrl();
            URL originServerUrl = null;
            try {
                originServerUrl = new URL(resourceUrl.getProtocol(), resourceUrl.getHost(), resourceUrl.getPort(), "/");
            }
            catch (MalformedURLException malformedURLException) {}
            Vector usedConnections = (Vector)this.usedConnections.get(originServerUrl);
            usedConnections.remove(connection);
            Vector<HttpConnection> unusedConnections = (Vector<HttpConnection>)this.unusedConnections.get(originServerUrl);
            if (unusedConnections == null) {
                unusedConnections = new Vector<HttpConnection>(5);
                this.unusedConnections.put(originServerUrl, unusedConnections);
            }
            unusedConnections.addElement(connection);
            connection.setTimestamp(new Date());
        }

        private synchronized void recycle() {
            Vector<URL> staleOriginServerUrls = new Vector<URL>(3);
            Enumeration originServerUrls = this.unusedConnections.keys();
            while (originServerUrls.hasMoreElements()) {
                HttpConnection connection;
                URL originServerUrl = (URL)originServerUrls.nextElement();
                Vector connectionsVector = (Vector)this.unusedConnections.get(originServerUrl);
                if (connectionsVector.isEmpty()) {
                    staleOriginServerUrls.add(originServerUrl);
                    break;
                }
                Vector<HttpConnection> staleConnections = new Vector<HttpConnection>(5);
                Enumeration connectionsEnum = connectionsVector.elements();
                while (connectionsEnum.hasMoreElements()) {
                    long connectionTime;
                    connection = (HttpConnection)connectionsEnum.nextElement();
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - (connectionTime = connection.getTimestamp().getTime()) < this.connectionTimeout) continue;
                    staleConnections.addElement(connection);
                }
                connectionsEnum = staleConnections.elements();
                while (connectionsEnum.hasMoreElements()) {
                    connection = (HttpConnection)connectionsEnum.nextElement();
                    connectionsVector.remove(connection);
                    try {
                        connection.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Enumeration staleOriginServerUrlsEnum = staleOriginServerUrls.elements();
            while (staleOriginServerUrlsEnum.hasMoreElements()) {
                this.unusedConnections.remove(staleOriginServerUrlsEnum.nextElement());
            }
        }

        public void run() {
            while (!ConnectionsRecycler.interrupted()) {
                try {
                    Thread.sleep(this.connectionTimeout);
                    this.recycle();
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            }
        }

        public void setConnectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }
    }

    class PersistentInputStream
    extends FilterInputStream {
        private HttpConnection connection;

        PersistentInputStream(HttpConnection connection) throws IOException {
            super(null);
            try {
                this.in = connection.getInputStream();
            }
            catch (IOException e) {
                this.closeConnection();
                throw e;
            }
            this.connection = connection;
        }

        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException e) {
                this.closeConnection();
                throw e;
            }
        }

        public void close() throws IOException {
            try {
                try {
                    super.close();
                }
                catch (IOException e) {
                    this.closeConnection();
                    throw e;
                }
            }
            finally {
                HttpClient.this.connectionsRecycler.putConnection(this.connection);
            }
        }

        private void closeConnection() {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {}
        }

        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (IOException e) {
                this.closeConnection();
                throw e;
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                return super.read(b);
            }
            catch (IOException e) {
                this.closeConnection();
                throw e;
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return super.read(b, off, len);
            }
            catch (IOException e) {
                this.closeConnection();
                throw e;
            }
        }

        public synchronized void reset() throws IOException {
            try {
                super.reset();
            }
            catch (IOException e) {
                this.closeConnection();
                throw e;
            }
        }

        public long skip(long n) throws IOException {
            try {
                return super.skip(n);
            }
            catch (IOException e) {
                this.closeConnection();
                throw e;
            }
        }
    }
}

