/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.base.ClassObjectType;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DroolsError;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.GroupElement;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.ObjectType;
import org.eclipse.core.resources.IResource;

public class DRLInfo {
    private static final DroolsError[] EMPTY_DROOLS_ERROR_ARRAY = new DroolsError[0];
    private static final List<DroolsError> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private final String sourcePathName;
    private final PackageDescr packageDescr;
    private List<DroolsError> parserErrors;
    private Package compiledPackage;
    private DroolsError[] builderErrors;
    private transient RuleInfo[] ruleInfos;
    private transient FunctionInfo[] functionInfos;
    private DialectCompiletimeRegistry dialectRegistry;
    private IResource resource;

    public DRLInfo(String sourcePathName, PackageDescr packageDescr, List<DroolsError> parserErrors, DialectCompiletimeRegistry dialectRegistry) {
        if (sourcePathName == null) {
            throw new IllegalArgumentException("Invalid sourcePathName " + sourcePathName);
        }
        this.sourcePathName = sourcePathName;
        this.packageDescr = packageDescr;
        this.parserErrors = parserErrors;
        this.builderErrors = EMPTY_DROOLS_ERROR_ARRAY;
        this.dialectRegistry = dialectRegistry;
    }

    public DRLInfo(String pathName, PackageDescr packageDescr, List<DroolsError> parserErrors, Package compiledPackage, DroolsError[] builderErrors, DialectCompiletimeRegistry dialectRegistry) {
        this(pathName, packageDescr, parserErrors, dialectRegistry);
        if (compiledPackage == null) {
            throw new IllegalArgumentException("Null package");
        }
        this.compiledPackage = compiledPackage;
        this.builderErrors = builderErrors == null ? EMPTY_DROOLS_ERROR_ARRAY : builderErrors;
    }

    public String getSourcePathName() {
        return this.sourcePathName;
    }

    public PackageDescr getPackageDescr() {
        return this.packageDescr;
    }

    public List<DroolsError> getParserErrors() {
        return this.parserErrors;
    }

    public void addError(DroolsError error) {
        this.parserErrors.add(error);
    }

    public Package getPackage() {
        return this.compiledPackage;
    }

    public DroolsError[] getBuilderErrors() {
        return this.builderErrors;
    }

    public String getPackageName() {
        return this.packageDescr == null ? null : this.packageDescr.getName();
    }

    public boolean isCompiled() {
        return this.compiledPackage != null;
    }

    public RuleInfo[] getRuleInfos() {
        if (this.ruleInfos == null) {
            ArrayList<RuleInfo> ruleInfosList = new ArrayList<RuleInfo>();
            if (this.packageDescr != null) {
                for (RuleDescr ruleDescr : this.packageDescr.getRules()) {
                    RuleInfo ruleInfo = new RuleInfo(this.packageDescr, this.compiledPackage, ruleDescr, this.dialectRegistry, this.sourcePathName);
                    ruleInfosList.add(ruleInfo);
                }
            }
            this.ruleInfos = ruleInfosList.toArray(new RuleInfo[0]);
        }
        return this.ruleInfos;
    }

    public RuleInfo getRuleInfo(int drlLineNumber) {
        RuleInfo[] ruleInfos = this.getRuleInfos();
        int ruleLine = -1;
        RuleInfo result = null;
        int i = 0;
        while (i < ruleInfos.length) {
            int ruleDrlLineNumber = ruleInfos[i].getDrlLineNumber();
            if (ruleDrlLineNumber > ruleLine && ruleDrlLineNumber <= drlLineNumber + 1) {
                ruleLine = ruleDrlLineNumber;
                result = ruleInfos[i];
            }
            ++i;
        }
        return result;
    }

    public DialectCompiletimeRegistry getDialectRegistry() {
        return this.dialectRegistry;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public FunctionInfo[] getFunctionInfos() {
        if (this.functionInfos == null) {
            ArrayList<FunctionInfo> functionInfosList = new ArrayList<FunctionInfo>();
            if (this.packageDescr != null) {
                for (FunctionDescr functionDescr : this.packageDescr.getFunctions()) {
                    FunctionInfo functionInfo = new FunctionInfo(this.packageDescr, this.compiledPackage, functionDescr, this.sourcePathName);
                    functionInfosList.add(functionInfo);
                }
            }
            this.functionInfos = functionInfosList.toArray(new FunctionInfo[0]);
        }
        return this.functionInfos;
    }

    public FunctionInfo getFunctionInfo(int drlLineNumber) {
        FunctionInfo[] functionInfos = this.getFunctionInfos();
        int functionLine = -1;
        FunctionInfo result = null;
        int i = 0;
        while (i < functionInfos.length) {
            int functionDrlLineNumber = functionInfos[i].getDrlLineNumber();
            if (functionDrlLineNumber > functionLine && functionDrlLineNumber <= drlLineNumber + 1) {
                functionLine = functionDrlLineNumber;
                result = functionInfos[i];
            }
            ++i;
        }
        return result;
    }

    public static class FunctionInfo {
        private final PackageDescr packageDescr;
        private final Package compiledPackage;
        private final FunctionDescr functionDescr;
        private final String sourcePathName;
        private transient String className;
        private transient int javaLineNumber = -1;

        public FunctionInfo(PackageDescr packageDescr, Package compiledPackage, FunctionDescr functionDescr, String sourcePathName) {
            if (functionDescr == null) {
                throw new IllegalArgumentException("Null functionDescr");
            }
            this.packageDescr = packageDescr;
            this.compiledPackage = compiledPackage;
            this.functionDescr = functionDescr;
            this.sourcePathName = sourcePathName;
        }

        public String getSourcePathName() {
            return this.sourcePathName;
        }

        public String getClassName() {
            if (!this.isCompiled()) {
                throw new IllegalArgumentException("Package has not been compiled");
            }
            if (this.className == null) {
                this.className = this.functionDescr.getClassName();
            }
            return this.className;
        }

        public int getDrlLineNumber() {
            return this.functionDescr.getLine();
        }

        public int getJavaLineNumber() {
            if (this.javaLineNumber == -1) {
                if (!this.isCompiled()) {
                    throw new IllegalArgumentException("Package has not been compiled");
                }
                this.javaLineNumber = this.compiledPackage.getDialectRuntimeRegistry().getLineMappings(this.className).getOffset();
            }
            return this.javaLineNumber;
        }

        public String getPackageName() {
            return this.packageDescr == null ? null : this.packageDescr.getName();
        }

        public String getFunctionName() {
            return this.functionDescr.getName();
        }

        public int getFunctionStart() {
            return this.functionDescr.getStartCharacter() + 8;
        }

        public int getFunctionEnd() {
            return this.functionDescr.getEndCharacter() - 1;
        }

        public boolean isCompiled() {
            return this.compiledPackage != null;
        }
    }

    public static class PatternInfo {
        private final PatternDescr patternDescr;
        private final Pattern pattern;

        private PatternInfo(PatternDescr patternDescr, Pattern pattern) {
            this.patternDescr = patternDescr;
            this.pattern = pattern;
        }

        public String getPatternTypeName() {
            ObjectType objectType = this.pattern.getObjectType();
            return objectType instanceof ClassObjectType ? ((ClassObjectType)objectType).getClassType().getName() : "";
        }

        public int getStart() {
            return this.patternDescr.getStartCharacter();
        }

        public int getEnd() {
            return this.patternDescr.getEndCharacter();
        }

        public String toString() {
            return this.patternDescr.toString();
        }
    }

    public static class RuleInfo {
        private final PackageDescr packageDescr;
        private final Package compiledPackage;
        private final RuleDescr ruleDescr;
        private final DialectCompiletimeRegistry dialectRegistry;
        private final String sourcePathName;
        private transient String className;
        private transient int consequenceJavaLineNumber = -1;
        private transient List<PatternInfo> patternInfos = null;
        private transient int endPatternsCharacter = -1;

        public RuleInfo(PackageDescr packageDescr, Package compiledPackage, RuleDescr ruleDescr, DialectCompiletimeRegistry dialectRegistry, String sourcePathName) {
            if (ruleDescr == null) {
                throw new IllegalArgumentException("Null ruleDescr");
            }
            this.packageDescr = packageDescr;
            this.compiledPackage = compiledPackage;
            this.ruleDescr = ruleDescr;
            this.dialectRegistry = dialectRegistry;
            this.sourcePathName = sourcePathName;
        }

        public String getDialectName() {
            String dialectName = null;
            dialectName = ((AttributeDescr)this.ruleDescr.getAttributes().get("dialect")).getValue();
            if (dialectName == null && this.packageDescr != null) {
                for (AttributeDescr attribute : this.packageDescr.getAttributes()) {
                    if (!"dialect".equals(attribute.getName())) continue;
                    dialectName = attribute.getValue();
                    break;
                }
            }
            return dialectName;
        }

        public Dialect getDialect() {
            String dialectName = this.getDialectName();
            if (dialectName == null) {
                return null;
            }
            return this.dialectRegistry.getDialect(dialectName);
        }

        public String getSourcePathName() {
            return this.sourcePathName;
        }

        public String getClassName() {
            if (!this.isCompiled()) {
                throw new IllegalArgumentException("Package has not been compiled");
            }
            if (this.className == null) {
                String packageName = this.getPackageName();
                this.className = String.valueOf(packageName == null ? "" : String.valueOf(packageName) + ".") + this.ruleDescr.getClassName();
            }
            return this.className;
        }

        public int getConsequenceStart() {
            return this.endPatternsCharacter + 5;
        }

        public int getConsequenceEnd() {
            return this.getRuleEnd();
        }

        public int getRuleStart() {
            return this.ruleDescr.getStartCharacter() + 5;
        }

        public int getRuleEnd() {
            return this.ruleDescr.getEndCharacter() - 4;
        }

        public int getDrlLineNumber() {
            return this.ruleDescr.getLine();
        }

        public int getConsequenceDrlLineNumber() {
            return this.ruleDescr.getConsequenceLine();
        }

        public int getConsequenceJavaLineNumber() {
            if (this.consequenceJavaLineNumber == -1) {
                if (!this.isCompiled()) {
                    throw new IllegalArgumentException("Package has not been compiled");
                }
                DialectRuntimeRegistry datas = this.compiledPackage.getDialectRuntimeRegistry();
                LineMappings mappings = datas.getLineMappings(this.className);
                this.consequenceJavaLineNumber = mappings.getOffset();
            }
            return this.consequenceJavaLineNumber;
        }

        public boolean isCompiled() {
            return this.compiledPackage != null;
        }

        public String getPackageName() {
            return this.packageDescr == null ? null : this.packageDescr.getName();
        }

        public String getRuleName() {
            return this.ruleDescr.getName();
        }

        public Rule getRule() {
            return this.compiledPackage.getRule(this.getRuleName());
        }

        public String toString() {
            return this.ruleDescr.toString();
        }

        public List<PatternInfo> getPatternInfos() {
            if (this.patternInfos == null && this.isCompiled()) {
                this.patternInfos = this.findPatternInfos();
            }
            return this.patternInfos;
        }

        private List<PatternInfo> findPatternInfos() {
            ArrayList<PatternInfo> patternInfos = new ArrayList<PatternInfo>();
            this.traversePatternTree(patternInfos, this.getRule().getLhs().getChildren(), this.ruleDescr.getLhs().getDescrs());
            return patternInfos;
        }

        private void traversePatternTree(List<PatternInfo> patternInfos, List<RuleConditionElement> ruleElements, List<BaseDescr> lhsDescrs) {
            if (ruleElements.size() != lhsDescrs.size()) {
                throw new RuntimeException("Cannot traverse pattern tree");
            }
            int i = 0;
            while (i < ruleElements.size()) {
                RuleConditionElement ruleElement = ruleElements.get(i);
                BaseDescr lhsDescr = lhsDescrs.get(i);
                if (ruleElement instanceof Pattern && lhsDescr instanceof PatternDescr) {
                    patternInfos.add(new PatternInfo((PatternDescr)lhsDescr, (Pattern)ruleElement));
                    this.endPatternsCharacter = Math.max(this.endPatternsCharacter, ((PatternDescr)lhsDescr).getEndCharacter());
                } else if (ruleElement instanceof GroupElement && lhsDescr instanceof ConditionalElementDescr) {
                    this.traversePatternTree(patternInfos, ((GroupElement)ruleElement).getChildren(), ((ConditionalElementDescr)lhsDescr).getDescrs());
                } else {
                    throw new RuntimeException("Cannot traverse pattern tree");
                }
                ++i;
            }
        }
    }
}

