/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.flow.common.editor.ProcessExtension;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ProcessWrapper;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.ProcessEditPart;
import org.drools.eclipse.flow.common.editor.editpart.ProcessEditPartFactory;
import org.drools.eclipse.flow.common.editor.editpart.figure.ElementFigure;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.jbpm.process.core.Process;

public class ProcessInstanceViewer
extends ViewPart
implements ISelectionListener {
    private CTabFolder tabFolder;
    private Map<String, ProcessInstanceTabItem> processInstanceTabItems = new HashMap<String, ProcessInstanceTabItem>();

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        this.tabFolder = new CTabFolder(parent, 64);
        this.tabFolder.setBorderVisible(true);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData);
    }

    public void setFocus() {
    }

    public void showProcessInstance(String processInstanceId, String processId, List nodeIds, String projectName) {
        this.processInstanceTabItems.put(processInstanceId, new ProcessInstanceTabItem(this.tabFolder, processInstanceId, processId, nodeIds, projectName));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    private IJavaProject getJavaProject(String projectName) {
        IProject project;
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null) {
            try {
                IJavaProject javaProject;
                if (project.getNature("org.eclipse.jdt.core.javanature") != null && (javaProject = JavaCore.create((IProject)project)).exists()) {
                    return javaProject;
                }
            }
            catch (CoreException e) {
                DroolsEclipsePlugin.log(e);
            }
        }
        return null;
    }

    private class ProcessInstanceTabItem {
        private GraphicalViewer graphicalViewer;
        private CTabItem tabItem;
        private String projectName;

        public ProcessInstanceTabItem(CTabFolder folder, String processInstanceId, String processId, List<String> nodeIds, String projectName) {
            IConfigurationElement[] extensions;
            this.projectName = projectName;
            this.tabItem = new CTabItem(folder, 0);
            ProcessInfo processInfo = DroolsEclipsePlugin.getDefault().getProcessInfo(processId);
            if (processInfo == null) {
                throw new IllegalArgumentException("Could not find process with id " + processId);
            }
            this.tabItem.setText(String.valueOf(processInstanceId) + " = " + processInfo.getProcess().getName() + "[" + processInfo.getProcessId() + "]");
            Composite composite = new Composite((Composite)folder, 0);
            composite.setLayout((Layout)new FillLayout());
            this.tabItem.setControl((Control)composite);
            this.graphicalViewer = new ScrollingGraphicalViewer();
            this.graphicalViewer.createControl(composite);
            this.graphicalViewer.getControl().setBackground(ColorConstants.listBackground);
            this.graphicalViewer.setRootEditPart((RootEditPart)new ScalableRootEditPart());
            IJavaProject javaProject = ProcessInstanceViewer.this.getJavaProject(projectName);
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor("org.drools.eclipse.processExtension");
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    ProcessExtension processExtension = (ProcessExtension)element.createExecutableExtension("className");
                    Process process = (Process)processInfo.getProcess();
                    if (processExtension.acceptsProcess(process.getType())) {
                        ProcessEditPartFactory editPartFactory = processExtension.getProcessEditPartFactory();
                        editPartFactory.setProject(javaProject);
                        this.graphicalViewer.setEditPartFactory((EditPartFactory)editPartFactory);
                        ProcessWrapper processWrapper = processExtension.getProcessWrapperBuilder().getProcessWrapper((org.kie.definition.process.Process)process, javaProject);
                        this.graphicalViewer.setContents((Object)processWrapper);
                        break;
                    }
                }
                catch (CoreException e) {
                    DroolsEclipsePlugin.log(e);
                }
                ++n2;
            }
            for (String nodeId : nodeIds) {
                this.handleNodeInstanceSelection(nodeId);
            }
            folder.setSelection(this.tabItem);
        }

        private void handleNodeInstanceSelection(String nodeId) {
            boolean found = false;
            for (ElementEditPart elementEditPart : ((ProcessEditPart)this.graphicalViewer.getContents()).getChildren()) {
                if (!((ElementWrapper)elementEditPart.getModel()).getId().equals(nodeId)) continue;
                ((ElementFigure)elementEditPart.getFigure()).setSelected(true);
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Could not find node with id " + nodeId);
            }
        }

        public CTabItem getTabItem() {
            return this.tabItem;
        }
    }
}

