/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.DroolsDebugEventHandlerView;
import org.drools.eclipse.debug.DroolsDebugViewContentProvider;
import org.drools.eclipse.debug.VariableWrapper;
import org.drools.reteoo.ReteooStatefulSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.jbpm.process.instance.ProcessInstance;

public class ProcessInstancesViewContentProvider
extends DroolsDebugViewContentProvider {
    private DroolsDebugEventHandlerView view;

    public ProcessInstancesViewContentProvider(DroolsDebugEventHandlerView view) {
        this.view = view;
    }

    @Override
    protected String getEmptyString() {
        return "The selected working memory has no process instances.";
    }

    @Override
    public Object[] getChildren(Object obj) {
        try {
            IVariable[] instances = null;
            if (obj != null && obj instanceof IJavaObject && "org.drools.reteoo.ReteooStatefulSession".equals(((IJavaObject)obj).getReferenceTypeName())) {
                instances = this.getProcessInstances((IJavaObject)obj);
            } else if (obj instanceof IVariable) {
                if (this.view.isShowLogicalStructure()) {
                    IValue value = this.getLogicalValue(((IVariable)obj).getValue(), new ArrayList());
                    instances = value.getVariables();
                }
                if (instances == null) {
                    instances = ((IVariable)obj).getValue().getVariables();
                }
            }
            if (instances == null) {
                return new Object[0];
            }
            this.cache(obj, instances);
            return instances;
        }
        catch (DebugException e) {
            DroolsEclipsePlugin.log(e);
            return new Object[0];
        }
    }

    private IVariable[] getProcessInstances(IJavaObject stackObj) throws DebugException {
        IValue objects = DebugUtil.getValueByExpression("return getProcessInstances().toArray();", (IValue)stackObj);
        if (objects instanceof IJavaArray) {
            IJavaArray array = (IJavaArray)objects;
            ArrayList<VariableWrapper> result = new ArrayList<VariableWrapper>();
            IJavaValue[] javaVals = array.getValues();
            int i = 0;
            while (i < javaVals.length) {
                IJavaValue processInstance = javaVals[i];
                String id = null;
                IVariable[] vars = processInstance.getVariables();
                int j = 0;
                while (j < vars.length) {
                    IVariable var = vars[j];
                    if ("id".equals(var.getName())) {
                        id = var.getValue().getValueString();
                    }
                    ++j;
                }
                result.add(new VariableWrapper("[" + id + "]", processInstance));
                ++i;
            }
            return result.toArray(new IVariable[result.size()]);
        }
        return null;
    }

    private ProcessInstance[] getProcessInstances(ReteooStatefulSession session) {
        return (ProcessInstance[])session.getProcessInstances().toArray();
    }
}

