/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.dsl.editor.DSLContentProvider;
import org.drools.eclipse.dsl.editor.DSLLabelProvider;
import org.drools.eclipse.dsl.editor.DSLMappingSorter;
import org.drools.eclipse.dsl.editor.MappingEditor;
import org.drools.eclipse.dsl.editor.NLGrammarModel;
import org.drools.lang.dsl.AntlrDSLMappingEntry;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.MappingError;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class DSLEditor
extends EditorPart {
    private Table table;
    private TableViewer tableViewer;
    private NLGrammarModel model;
    private boolean dirty = false;
    private Text exprText;
    private Text mappingText;
    private Text descriptionText;
    private Text objText;
    private Combo sortCombo;

    public void doSave(IProgressMonitor monitor) {
        FileEditorInput input = (FileEditorInput)this.getEditorInput();
        File outputFile = input.getFile().getLocation().toFile();
        this.saveFile(monitor, outputFile, input);
    }

    private void saveFile(IProgressMonitor monitor, File outputFile, FileEditorInput input) {
        try {
            this.validate(input);
            FileWriter writer = new FileWriter(outputFile);
            DSLMappingFile.saveMapping((Writer)writer, (DSLMapping)this.model);
            this.makeClean();
            writer.close();
            input.getFile().getProject().refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to save DSL configuration file. (IOException: " + e.getMessage() + ")");
        }
        catch (CoreException e) {
            throw new IllegalStateException("Unable to resync workbench after DSL save. (CoreException: " + e.getMessage() + ")");
        }
    }

    private void validate(FileEditorInput input) {
        this.removeProblemsFor((IResource)input.getFile());
        ArrayList errs = new ArrayList();
        for (DSLMappingEntry item : this.model.getEntries()) {
            errs.addAll(item.getErrors());
        }
        if (errs.size() > 0) {
            for (MappingError mapEr : errs) {
                this.createMarker((IResource)input.getFile(), String.valueOf(mapEr.getMessage()) + "  From [" + mapEr.getTemplateText() + "]", -1);
            }
        }
    }

    private void createMarker(final IResource res, final String message, final int lineNumber) {
        try {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker = res.createMarker("org.drools.eclipse.problem");
                    marker.setAttribute("message", (Object)message);
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("lineNumber", lineNumber);
                }
            };
            res.getWorkspace().run(r, null, 1, null);
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    private void removeProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.drools.eclipse.problem", false, 2);
            }
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    void makeClean() {
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.setVisibleName(editorInput);
        try {
            FileEditorInput input;
            InputStream stream = null;
            if (editorInput instanceof FileEditorInput) {
                input = (FileEditorInput)editorInput;
                stream = input.getFile().getContents();
            } else if (editorInput instanceof IStorageEditorInput) {
                input = (IStorageEditorInput)editorInput;
                stream = input.getStorage().getContents();
            }
            this.model = new NLGrammarModel();
            DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
            file.parseAndLoad((Reader)new InputStreamReader(stream));
            this.model.addEntries(file.getMapping().getEntries());
            stream.close();
        }
        catch (CoreException e) {
            throw new IllegalStateException("Unable to load DSL configuration file. (CoreException: " + e.getMessage() + ")");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unabel to close stream fo DSL config file. (IOException: " + e.getMessage() + ")");
        }
    }

    private void setVisibleName(IEditorInput input) {
        this.setPartName(input.getName());
        this.setContentDescription("Editing Domain specific language: [" + input.getName() + "]");
    }

    public boolean isDirty() {
        return this.dirty;
    }

    void makeDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public void sortModel() {
        if (this.sortCombo.getSelectionIndex() == 1) {
            this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(1));
        } else if (this.sortCombo.getSelectionIndex() == 0) {
            this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(0));
        } else if (this.sortCombo.getSelectionIndex() == 3) {
            this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(3));
        } else if (this.sortCombo.getSelectionIndex() == 2) {
            this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(2));
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 4;
        parent.setLayout((Layout)layout);
        this.createDescriptionField(parent);
        this.createTable(parent);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new DSLContentProvider(this.tableViewer, this.model));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DSLLabelProvider());
        this.refreshModel();
        this.createExpressionViewField(parent);
        this.createEditButton(parent);
        this.createMappingViewField(parent);
        this.createDeleteButton(parent);
        this.createObjectViewField(parent);
        this.createAddButton(parent);
        this.createSortField(parent);
        this.createSortButton(parent);
        this.createCopyButton(parent);
        this.createTableListeners();
    }

    private void createTableListeners() {
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.populate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.populate();
            }

            private void populate() {
                DSLMappingEntry selected = DSLEditor.this.getCurrentSelected();
                DSLEditor.this.exprText.setText(selected.getMappingKey());
                DSLEditor.this.mappingText.setText(selected.getMappingValue());
                DSLEditor.this.objText.setText(selected.getMetaData().getMetaData() == null ? "" : selected.getMetaData().getMetaData());
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                DSLEditor.this.showEditPopup();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createDescriptionField(Composite parent) {
        Label descLbl = new Label(parent, 0);
        descLbl.setText("Description:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        descLbl.setLayoutData((Object)gridData);
        this.descriptionText = new Text(parent, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        this.descriptionText.setText(this.model.getDescription() == null ? "" : this.model.getDescription());
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = DSLEditor.this.descriptionText.getText();
                if (!text.equals(DSLEditor.this.model.getDescription())) {
                    DSLEditor.this.model.setDescription(text);
                    DSLEditor.this.makeDirty();
                }
            }
        });
    }

    private void createMappingViewField(Composite parent) {
        Label mapping = new Label(parent, 0);
        mapping.setText("Mapping:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        mapping.setLayoutData((Object)gridData);
        this.mappingText = new Text(parent, 2048);
        this.mappingText.setEditable(false);
        this.mappingText.setLayoutData((Object)new GridData(768));
    }

    private void createExpressionViewField(Composite parent) {
        Label expr = new Label(parent, 0);
        expr.setText("Expression:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        expr.setLayoutData((Object)gridData);
        this.exprText = new Text(parent, 2048);
        this.exprText.setEditable(false);
        gridData = new GridData(768);
        this.exprText.setLayoutData((Object)gridData);
    }

    private void createObjectViewField(Composite parent) {
        Label obj = new Label(parent, 0);
        obj.setText("Object:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        obj.setLayoutData((Object)gridData);
        this.objText = new Text(parent, 2048);
        this.objText.setEditable(false);
        gridData = new GridData(768);
        this.objText.setLayoutData((Object)gridData);
    }

    private void createSortField(Composite parent) {
        Label sort = new Label(parent, 0);
        sort.setText("Sort by:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        sort.setLayoutData((Object)gridData);
        this.sortCombo = new Combo(parent, 8);
        this.sortCombo.add("Object", 0);
        this.sortCombo.add("Language Expression", 1);
        this.sortCombo.add("Rule Language Mapping", 2);
        this.sortCombo.add("Scope", 3);
        gridData = new GridData(768);
        this.sortCombo.setLayoutData((Object)gridData);
    }

    private void refreshModel() {
        this.tableViewer.setInput((Object)this.model);
    }

    private void createEditButton(Composite parent) {
        Button add = new Button(parent, 0x1000008);
        add.setText("Edit");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSLEditor.this.showEditPopup();
            }
        });
    }

    private void showEditPopup() {
        DSLMappingEntry selected = this.getCurrentSelected();
        if (selected != null) {
            MappingEditor editor = new MappingEditor(this.getSite().getShell());
            editor.create();
            editor.getShell().setText("Edit language mapping");
            editor.setTitle("Edit an existing language mapping item.");
            editor.setTitleImage(this.getTitleImage());
            editor.setNLMappingItem(selected);
            editor.open();
            if (!editor.isCancelled()) {
                this.refreshModel();
                this.makeDirty();
                this.exprText.setText(selected.getMappingKey());
                this.mappingText.setText(selected.getMappingValue());
                this.objText.setText(selected.getMetaData().getMetaData() == null ? "" : selected.getMetaData().getMetaData());
            }
        }
    }

    private void createDeleteButton(Composite parent) {
        Button add = new Button(parent, 0x1000008);
        add.setText("Remove");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (DSLMappingEntry entry : DSLEditor.this.getAllSelected()) {
                    DSLEditor.this.model.removeEntry(entry);
                }
                DSLEditor.this.refreshModel();
                DSLEditor.this.makeDirty();
                DSLEditor.this.exprText.setText("");
                DSLEditor.this.mappingText.setText("");
                DSLEditor.this.objText.setText("");
            }
        });
    }

    private void createSortButton(Composite parent) {
        Button sort = new Button(parent, 0x1000008);
        sort.setText("Sort");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        sort.setLayoutData((Object)gridData);
        sort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSLEditor.this.sortModel();
                DSLEditor.this.refreshModel();
                DSLEditor.this.makeDirty();
            }
        });
    }

    private DSLMappingEntry getCurrentSelected() {
        return (DSLMappingEntry)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
    }

    private List<DSLMappingEntry> getAllSelected() {
        ArrayList<DSLMappingEntry> result = new ArrayList<DSLMappingEntry>();
        for (Object e : ((IStructuredSelection)this.tableViewer.getSelection()).toList()) {
            result.add((DSLMappingEntry)e);
        }
        return result;
    }

    private void createAddButton(Composite parent) {
        Button add = new Button(parent, 0x1000008);
        add.setText("Add");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntlrDSLMappingEntry newItem = new AntlrDSLMappingEntry();
                MappingEditor editor = new MappingEditor(DSLEditor.this.getSite().getShell());
                editor.create();
                editor.getShell().setText("New language mapping");
                editor.setTitle("Create a new language element mapping.");
                editor.setTitleImage(DSLEditor.this.getTitleImage());
                editor.setNLMappingItem((DSLMappingEntry)newItem);
                editor.open();
                if (!editor.isCancelled()) {
                    DSLEditor.this.model.addEntry((DSLMappingEntry)newItem);
                    DSLEditor.this.refreshModel();
                    DSLEditor.this.makeDirty();
                }
            }
        });
    }

    private void createCopyButton(Composite parent) {
        Button copy = new Button(parent, 0x1000008);
        copy.setText("Copy");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        copy.setLayoutData((Object)gridData);
        copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSLMappingEntry curr = DSLEditor.this.getCurrentSelected();
                if (curr != null) {
                    AntlrDSLMappingEntry newItem = new AntlrDSLMappingEntry(curr.getSection(), curr.getMetaData(), curr.getMappingKey(), curr.getMappingValue(), null, null);
                    MappingEditor editor = new MappingEditor(DSLEditor.this.getSite().getShell());
                    editor.create();
                    editor.getShell().setText("New language mapping");
                    editor.setTitle("Create a new language element mapping from a copy.");
                    editor.setTitleImage(DSLEditor.this.getTitleImage());
                    editor.setNLMappingItem((DSLMappingEntry)newItem);
                    editor.open();
                    if (!editor.isCancelled()) {
                        DSLEditor.this.model.addEntry((DSLMappingEntry)newItem);
                        DSLEditor.this.refreshModel();
                        DSLEditor.this.makeDirty();
                    }
                }
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
    }

    private void createTable(Composite parent) {
        int style = 101122;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText("Language Expression");
        column.setWidth(350);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSLEditor.this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 1);
        column.setText("Rule Language Mapping");
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSLEditor.this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(2));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText("Object");
        column.setWidth(80);
        column = new TableColumn(this.table, 16384, 3);
        column.setText("Scope");
        column.setWidth(80);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSLEditor.this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(3));
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }
}

