/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.util.StringUtils;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.DroolsPluginImages;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.completion.AbstractCompletionProcessor;
import org.drools.eclipse.editors.completion.CompletionUtil;
import org.drools.eclipse.editors.completion.RuleCompletionProposal;
import org.drools.lang.descr.GlobalDescr;
import org.drools.rule.builder.dialect.java.KnowledgeHelperFixer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class DefaultCompletionProcessor
extends AbstractCompletionProcessor {
    private static final String NEW_RULE_TEMPLATE = "rule \"new rule\"" + System.getProperty("line.separator") + "\twhen" + System.getProperty("line.separator") + "\t\t" + System.getProperty("line.separator") + "\tthen" + System.getProperty("line.separator") + "\t\t" + System.getProperty("line.separator") + "end";
    private static final String NEW_QUERY_TEMPLATE = "query \"query name\"" + System.getProperty("line.separator") + "\t#conditions" + System.getProperty("line.separator") + "end";
    private static final String NEW_FUNCTION_TEMPLATE = "function void yourFunction(Type arg) {" + System.getProperty("line.separator") + "\t/* code goes here*/" + System.getProperty("line.separator") + "}";
    private static final String NEW_TEMPLATE_TEMPLATE = "template Name" + System.getProperty("line.separator") + "\t" + System.getProperty("line.separator") + "end";
    protected static final Pattern IMPORT_PATTERN = Pattern.compile(".*\n\\W*import\\W[^;\\s]*", 32);
    private static final Pattern FUNCTION_PATTERN = Pattern.compile(".*\n\\W*function\\s+(\\S+)\\s+(\\S+)\\s*\\(([^\\)]*)\\)\\s*\\{([^\\}]*)", 32);
    protected static final Image VARIABLE_ICON = DroolsPluginImages.getImage("Variable");
    protected static final Image METHOD_ICON = DroolsPluginImages.getImage("Method");
    protected static final Image CLASS_ICON = DroolsPluginImages.getImage("Class");

    public DefaultCompletionProcessor(AbstractRuleEditor editor) {
        super((IEditorPart)editor);
    }

    @Override
    protected List getCompletionProposals(ITextViewer viewer, int documentOffset) {
        try {
            IDocument doc = viewer.getDocument();
            String backText = this.readBackwards(documentOffset, doc);
            String prefix = CompletionUtil.stripLastWord(backText);
            List<RuleCompletionProposal> props = null;
            Matcher matcher = IMPORT_PATTERN.matcher(backText);
            if (matcher.matches()) {
                String classNameStart = backText.substring(backText.lastIndexOf("import") + 7);
                props = this.getAllClassProposals(classNameStart, documentOffset, prefix);
            } else {
                matcher = FUNCTION_PATTERN.matcher(backText);
                if (matcher.matches()) {
                    Map params = this.extractParams(matcher.group(3));
                    String functionText = matcher.group(4);
                    props = this.getJavaCompletionProposals(documentOffset, functionText, prefix, params, false, false);
                    DefaultCompletionProcessor.filterProposalsOnPrefix(prefix, props);
                } else {
                    props = this.getPossibleProposals(viewer, documentOffset, backText, prefix);
                }
            }
            return props;
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
            return null;
        }
    }

    private Map extractParams(String params) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] parameters = StringUtils.split((String)params, (String)",");
        int i = 0;
        while (i < parameters.length) {
            String[] typeAndName = StringUtils.split((String)parameters[i]);
            if (typeAndName.length == 2) {
                result.put(typeAndName[1], typeAndName[0]);
            }
            ++i;
        }
        return result;
    }

    private IJavaProject getCurrentJavaProject() {
        IEditorInput input = this.getEditor().getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        IProject project = ((IFileEditorInput)input).getFile().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject;
    }

    protected List getAllClassProposals(String classNameStart, int documentOffset, String prefix) {
        ArrayList<IJavaCompletionProposal> result = new ArrayList<IJavaCompletionProposal>();
        IJavaProject javaProject = this.getCurrentJavaProject();
        if (javaProject == null) {
            return result;
        }
        CompletionProposalCollector collector = new CompletionProposalCollector(javaProject){

            public void accept(CompletionProposal proposal) {
                if (proposal.getKind() == 8 || proposal.getKind() == 9) {
                    super.accept(proposal);
                }
            }
        };
        collector.acceptContext(new CompletionContext());
        try {
            IEvaluationContext evalContext = javaProject.newEvaluationContext();
            evalContext.codeComplete(classNameStart, classNameStart.length(), (CompletionRequestor)collector);
            IJavaCompletionProposal[] proposals = collector.getJavaCompletionProposals();
            int i = 0;
            while (i < proposals.length) {
                if (proposals[i] instanceof AbstractJavaCompletionProposal) {
                    String completionPrefix;
                    int dotIndex;
                    AbstractJavaCompletionProposal javaProposal = (AbstractJavaCompletionProposal)proposals[i];
                    int replacementOffset = documentOffset - (classNameStart.length() - javaProposal.getReplacementOffset());
                    javaProposal.setReplacementOffset(replacementOffset);
                    if (javaProposal instanceof LazyJavaTypeCompletionProposal && (dotIndex = (completionPrefix = classNameStart.substring(classNameStart.length() - javaProposal.getReplacementLength())).lastIndexOf(46)) != -1) {
                        javaProposal.setReplacementString(((LazyJavaTypeCompletionProposal)javaProposal).getQualifiedTypeName());
                    }
                    result.add(proposals[i]);
                }
                ++i;
            }
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
        return result;
    }

    protected List<RuleCompletionProposal> getPossibleProposals(ITextViewer viewer, int documentOffset, String backText, String prefix) {
        ArrayList<RuleCompletionProposal> list = new ArrayList<RuleCompletionProposal>();
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "rule", NEW_RULE_TEMPLATE, 6));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "import", "import "));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "expander", "expander "));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "global", "global "));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "package", "package "));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "query", NEW_QUERY_TEMPLATE));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "function", NEW_FUNCTION_TEMPLATE, 14));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "template", NEW_TEMPLATE_TEMPLATE, 9));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "dialect \"java\"", "dialect \"java\" "));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "dialect \"mvel\"", "dialect \"mvel\" "));
        DefaultCompletionProcessor.filterProposalsOnPrefix(prefix, list);
        return list;
    }

    protected List<RuleCompletionProposal> getJavaCompletionProposals(int documentOffset, String javaText, String prefix, Map params) {
        return this.getJavaCompletionProposals(documentOffset, javaText, prefix, params, true, false);
    }

    protected List<RuleCompletionProposal> getJavaCompletionProposals(int documentOffset, String javaText, String prefix, Map params, boolean useDrools, boolean useContext) {
        ArrayList<RuleCompletionProposal> list = new ArrayList<RuleCompletionProposal>();
        this.requestJavaCompletionProposals(javaText, prefix, documentOffset, params, list, useDrools, useContext);
        return list;
    }

    protected static boolean doesNotContainFieldCompletion(String completion, List completions) {
        if (completion == null || completion.length() == 0 || completions == null) {
            return false;
        }
        for (Object o : completions) {
            IJavaElement javaElement;
            AbstractJavaCompletionProposal prop;
            String content;
            if (!(o instanceof AbstractJavaCompletionProposal) || !completion.equals(content = (prop = (AbstractJavaCompletionProposal)o).getReplacementString()) || !((javaElement = prop.getJavaElement()) instanceof ILocalVariable) && !(javaElement instanceof IField)) continue;
            return false;
        }
        return true;
    }

    protected void requestJavaCompletionProposals(String javaText, String prefix, int documentOffset, Map params, Collection results) {
        this.requestJavaCompletionProposals(javaText, prefix, documentOffset, params, results, true, false);
    }

    protected void requestJavaCompletionProposals(String javaText, String prefix, int documentOffset, Map params, Collection results, boolean useDrools, boolean useContext) {
        IJavaProject javaProject;
        String javaTextWithoutPrefix = CompletionUtil.getTextWithoutPrefix(javaText, prefix);
        boolean filterObjectMethods = false;
        if ("".equals(javaTextWithoutPrefix.trim()) || CompletionUtil.START_OF_NEW_JAVA_STATEMENT.matcher(javaTextWithoutPrefix).matches()) {
            filterObjectMethods = true;
        }
        if ((javaProject = this.getCurrentJavaProject()) == null) {
            return;
        }
        CompletionProposalCollector collector = new CompletionProposalCollector(javaProject);
        collector.acceptContext(new CompletionContext());
        try {
            IEvaluationContext evalContext = javaProject.newEvaluationContext();
            List<String> imports = this.getImports();
            if (imports != null && imports.size() > 0) {
                evalContext.setImports(imports.toArray(new String[imports.size()]));
            }
            StringBuffer javaTextWithParams = new StringBuffer();
            for (Map.Entry entry : params.entrySet()) {
                javaTextWithParams.append(entry.getValue() + " " + entry.getKey() + ";\n");
            }
            if (useDrools) {
                javaTextWithParams.append("org.drools.spi.KnowledgeHelper drools;");
                javaTextWithParams.append("org.kie.runtime.rule.RuleContext kcontext;");
            }
            if (useContext) {
                javaTextWithParams.append("org.drools.spi.ProcessContext context;");
                javaTextWithParams.append("org.drools.runtime.process.ProcessContext kcontext;");
            }
            javaTextWithParams.append(javaText);
            String jtext = javaTextWithParams.toString();
            new KnowledgeHelperFixer();
            String fixedText = KnowledgeHelperFixer.fix((String)jtext);
            evalContext.codeComplete(fixedText, fixedText.length(), (CompletionRequestor)collector);
            IJavaCompletionProposal[] proposals = collector.getJavaCompletionProposals();
            int i = 0;
            while (i < proposals.length) {
                if (proposals[i] instanceof AbstractJavaCompletionProposal) {
                    String completionPrefix;
                    int dotIndex;
                    AbstractJavaCompletionProposal javaProposal = (AbstractJavaCompletionProposal)proposals[i];
                    int replacementOffset = documentOffset - (fixedText.length() - javaProposal.getReplacementOffset());
                    javaProposal.setReplacementOffset(replacementOffset);
                    if (javaProposal instanceof LazyJavaTypeCompletionProposal && (dotIndex = (completionPrefix = javaText.substring(javaText.length() - javaProposal.getReplacementLength())).lastIndexOf(46)) != -1) {
                        javaProposal.setReplacementString(((LazyJavaTypeCompletionProposal)javaProposal).getQualifiedTypeName());
                    }
                    if (!filterObjectMethods || !(proposals[i] instanceof JavaMethodCompletionProposal)) {
                        results.add(proposals[i]);
                    }
                }
                ++i;
            }
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
    }

    protected String getPackage() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getPackage();
        }
        return "";
    }

    protected List<String> getImports() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getImports();
        }
        return Collections.EMPTY_LIST;
    }

    protected Set getUniqueImports() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.getImports());
        return set;
    }

    protected List getFunctions() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getFunctions();
        }
        return Collections.EMPTY_LIST;
    }

    protected Map getAttributes() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getAttributes();
        }
        return Collections.EMPTY_MAP;
    }

    protected List<GlobalDescr> getGlobals() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getGlobals();
        }
        return Collections.EMPTY_LIST;
    }

    protected List<String> getClassesInPackage() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getClassesInPackage();
        }
        return Collections.EMPTY_LIST;
    }
}

