/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.drools.eclipse.reteoo.BaseVertex;

public class Row {
    private final int depth;
    private List vertices = new ArrayList();

    public Row(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void add(BaseVertex vertex) {
        this.vertices.add(vertex);
    }

    public List getVertices() {
        return this.vertices;
    }

    public boolean contains(BaseVertex vertex) {
        return this.vertices.contains(vertex);
    }

    public int getWidth() {
        return this.vertices.size();
    }

    public void optimize() {
        ArrayList sorted = new ArrayList(this.vertices);
        Collections.sort(sorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                int v2OutDegree;
                BaseVertex v1 = (BaseVertex)o1;
                BaseVertex v2 = (BaseVertex)o2;
                int v1OutDegree = v1.getSourceConnections().size();
                if (v1OutDegree < (v2OutDegree = v2.getSourceConnections().size())) {
                    return 1;
                }
                if (v1OutDegree > v2OutDegree) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedList<BaseVertex> optimized = new LinkedList<BaseVertex>();
        boolean front = false;
        for (BaseVertex vertex : sorted) {
            if (front) {
                optimized.addFirst(vertex);
            } else {
                optimized.addLast(vertex);
            }
            boolean bl = front = !front;
        }
        this.vertices = optimized;
    }
}

