/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.ImportCompletionProcessor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jbpm.workflow.core.WorkflowProcess;

public class RuleFlowImportsDialog
extends Dialog {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("\\n\\s*import\\s+([^\\s;#]+);?", 32);
    private static final Pattern FUNCTION_IMPORT_PATTERN = Pattern.compile("\\n\\s*import\\s+function\\s+([^\\s;#]+);?", 32);
    private WorkflowProcess process;
    private boolean success;
    private TabFolder tabFolder;
    private SourceViewer importsViewer;
    private List<String> imports;
    private List<String> functionImports;

    public RuleFlowImportsDialog(Shell parentShell, WorkflowProcess process) {
        super(parentShell);
        this.process = process;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Imports editor");
    }

    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite parent) {
        this.importsViewer = new SourceViewer(parent, null, 2048);
        this.importsViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            @Override
            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                return null;
            }

            @Override
            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                ImportCompletionProcessor completionProcessor = new ImportCompletionProcessor();
                assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__dftl_partition_content_type");
                assistant.setProposalPopupOrientation(10);
                return assistant;
            }
        });
        Document document = new Document(this.getProcessImports());
        this.importsViewer.setDocument((IDocument)document);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.importsViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' && e.stateMask == 262144) {
                    RuleFlowImportsDialog.this.importsViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.importsViewer.getControl();
    }

    private String getProcessImports() {
        String result = "// define your imports here: e.g. import com.sample.MyClass\n";
        List imports = this.process.getImports();
        if (imports != null) {
            for (String importString : imports) {
                result = String.valueOf(result) + "import " + importString + "\n";
            }
        }
        if ((imports = this.process.getFunctionImports()) != null) {
            for (String importString : imports) {
                result = String.valueOf(result) + "import function " + importString + "\n";
            }
        }
        return result;
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.tabFolder = new TabFolder(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gd);
        TabItem textEditorTab = new TabItem(this.tabFolder, 0);
        textEditorTab.setText("Imports");
        textEditorTab.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return this.tabFolder;
    }

    protected void okPressed() {
        this.success = true;
        this.updateImports();
        super.okPressed();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public List<String> getFunctionImports() {
        return this.functionImports;
    }

    private void updateImports() {
        this.imports = new ArrayList<String>();
        Matcher matcher = IMPORT_PATTERN.matcher(this.importsViewer.getDocument().get());
        while (matcher.find()) {
            String importString = matcher.group(1);
            if ("function".equals(importString)) continue;
            this.imports.add(importString);
        }
        this.functionImports = new ArrayList<String>();
        matcher = FUNCTION_IMPORT_PATTERN.matcher(this.importsViewer.getDocument().get());
        while (matcher.find()) {
            this.functionImports.add(matcher.group(1));
        }
    }
}

