/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.spi.Constraint;
import org.drools.eclipse.reteoo.AccumulateNodeVertex;
import org.drools.eclipse.reteoo.AlphaNodeVertex;
import org.drools.eclipse.reteoo.BaseVertex;
import org.drools.eclipse.reteoo.EntryPointNodeVertex;
import org.drools.eclipse.reteoo.EvalConditionNodeVertex;
import org.drools.eclipse.reteoo.ExistsNodeVertex;
import org.drools.eclipse.reteoo.FromNodeVertex;
import org.drools.eclipse.reteoo.JoinNodeVertex;
import org.drools.eclipse.reteoo.LeftInputAdapterNodeVertex;
import org.drools.eclipse.reteoo.NotNodeVertex;
import org.drools.eclipse.reteoo.ObjectTypeNodeVertex;
import org.drools.eclipse.reteoo.PropagationQueuingNodeVertex;
import org.drools.eclipse.reteoo.QueryTerminalNodeVertex;
import org.drools.eclipse.reteoo.ReteVertex;
import org.drools.eclipse.reteoo.RightInputAdapterNodeVertex;
import org.drools.eclipse.reteoo.RuleTerminalNodeVertex;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class VertexPropertySource
implements IPropertySource {
    private static final String VERTEX_FROM = "From BaseVertex";
    private static final String VERTEX_ACCUMULATE = "Accumulate BaseVertex";
    private static final String VERTEX_COLLECT = "Collect BaseVertex";
    private static final String VERTEX_EXISTS = "Exists BaseVertex";
    private static final String VERTEX_TERMINAL = "Terminal BaseVertex";
    private static final String VERTEX_QUERY_TERMINAL = "Query Terminal BaseVertex";
    private static final String VERTEX_EVAL_CONDITION = "Eval Condition BaseVertex";
    private static final String VERTEX_NOT = "Not BaseVertex";
    private static final String VERTEX_JOIN = "Join BaseVertex";
    private static final String VERTEX_RIGHT_INPUT_ADAPTER = "Right Input Adapter BaseVertex";
    private static final String VERTEX_LEFT_INPUT_ADAPTER = "Left Input Adapter BaseVertex";
    private static final String VERTEX_ALPHA = "Alpha BaseVertex";
    private static final String VERTEX_OBJECT_TYPE = "Object Type BaseVertex";
    private static final String VERTEX_RETE = "Rete BaseVertex";
    private static final String VERTEX_ENTRY_POINT = "Entry Point BaseVertex";
    private static final String VERTEX_PROPAGATION_QUEUING = "Propagation Queuing BaseVertex";
    private static final String CONSTRAINT_CAP = "Constraint";
    private static final String CONSTRAINT = "constraint";
    public String ID_ROOT = "vertex";
    public String ID_ID = "id";
    public String ID_HTML = "html";
    private IPropertyDescriptor[] descriptors;
    private final IPropertyDescriptor PROP_NAME = new PropertyDescriptor((Object)"name", "Name");
    private final IPropertyDescriptor PROP_ID = new PropertyDescriptor((Object)"id", "ID");
    private final IPropertyDescriptor PROP_RULE = new PropertyDescriptor((Object)"rule", "Rule");
    private final IPropertyDescriptor PROP_QUERY = new PropertyDescriptor((Object)"query", "Query");
    private final IPropertyDescriptor PROP_ALPHA_FIELD_NAME = new PropertyDescriptor((Object)"fieldName", "Field Name");
    private final IPropertyDescriptor PROP_ALPHA_EVALUATOR = new PropertyDescriptor((Object)"evaluator", "Evaluator");
    private final IPropertyDescriptor PROP_ALPHA_VALUE = new PropertyDescriptor((Object)"value", "Value");
    private final IPropertyDescriptor PROP_OBJ_TYPE = new PropertyDescriptor((Object)"objectType", "Object Type");
    private final IPropertyDescriptor PROP_EXP_OFFSET = new PropertyDescriptor((Object)"expirationOffset", "Expiration Offset");
    private final IPropertyDescriptor PROP_ENTRY_POINT_NAME = new PropertyDescriptor((Object)"entryPointName", "Entry Point Name");
    private static final String CAT_GENERAL = "General";
    private static final String CAT_OTHER = "Other";
    protected BaseVertex vertex = null;
    private Map values = new HashMap();

    public VertexPropertySource(BaseVertex vertex) {
        this.vertex = vertex;
        this.initProperties(vertex);
    }

    private final void initProperties(BaseVertex vertex) {
        ArrayList descriptorList = new ArrayList();
        if (vertex instanceof ExistsNodeVertex) {
            this.initExistsNodeProperties((ExistsNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof FromNodeVertex) {
            this.initFromNodeProperties((FromNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof AccumulateNodeVertex) {
            this.initAccumulateNodeProperties((AccumulateNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof RuleTerminalNodeVertex) {
            this.initTerminalNodeProperties((RuleTerminalNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof QueryTerminalNodeVertex) {
            this.initQueryTerminalNodeProperties((QueryTerminalNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof EvalConditionNodeVertex) {
            this.initEvalConditionNodeProperties((EvalConditionNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof NotNodeVertex) {
            this.initNotNodeProperties((NotNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof JoinNodeVertex) {
            this.initJoinNodeProperties((JoinNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof RightInputAdapterNodeVertex) {
            this.initRightInputAdapterNodeProperties(descriptorList, this.values);
        } else if (vertex instanceof LeftInputAdapterNodeVertex) {
            this.initLeftInputAdapterNodeProperties((LeftInputAdapterNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof AlphaNodeVertex) {
            this.initAlphaNodeProperties((AlphaNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof ObjectTypeNodeVertex) {
            this.initObjectTypeNodeProperties((ObjectTypeNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof ReteVertex) {
            this.initReteNodeProperties((ReteVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof PropagationQueuingNodeVertex) {
            this.initPropagationQueuingNodeProperties((PropagationQueuingNodeVertex)vertex, descriptorList, this.values);
        } else if (vertex instanceof EntryPointNodeVertex) {
            this.initEntryPointNodeProperties((EntryPointNodeVertex)vertex, descriptorList, this.values);
        }
        this.descriptors = descriptorList.toArray(new IPropertyDescriptor[0]);
    }

    private void initExistsNodeProperties(ExistsNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_EXISTS, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(vertex.getId()), descriptorList, valueMap);
    }

    private void initAccumulateNodeProperties(AccumulateNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_ACCUMULATE, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(vertex.getId()), descriptorList, valueMap);
    }

    private void initFromNodeProperties(FromNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_FROM, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(vertex.getId()), descriptorList, valueMap);
    }

    private void initReteNodeProperties(ReteVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_RETE, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(vertex.getId()), descriptorList, valueMap);
    }

    private void initObjectTypeNodeProperties(ObjectTypeNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_OBJECT_TYPE, descriptorList, valueMap);
        this.addProperty(this.PROP_OBJ_TYPE, vertex.getObjectType(), descriptorList, valueMap);
        this.addProperty(this.PROP_EXP_OFFSET, vertex.getExpirationOffset(), descriptorList, valueMap);
    }

    private void initAlphaNodeProperties(AlphaNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_ALPHA, descriptorList, valueMap);
        this.addProperty(this.PROP_ALPHA_FIELD_NAME, vertex.getFieldName(), descriptorList, valueMap);
        this.addProperty(this.PROP_ALPHA_EVALUATOR, vertex.getEvaluator(), descriptorList, valueMap);
        this.addProperty(this.PROP_ALPHA_VALUE, vertex.getValue(), descriptorList, valueMap);
        Constraint constraint = vertex.getConstraint();
        if (constraint == null) {
            return;
        }
        PropertyDescriptor prop = new PropertyDescriptor((Object)CONSTRAINT, CONSTRAINT_CAP);
        this.addProperty((IPropertyDescriptor)prop, constraint.toString(), descriptorList, valueMap);
    }

    private void initLeftInputAdapterNodeProperties(LeftInputAdapterNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_LEFT_INPUT_ADAPTER, descriptorList, valueMap);
    }

    private void initRightInputAdapterNodeProperties(List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_RIGHT_INPUT_ADAPTER, descriptorList, valueMap);
    }

    private void initJoinNodeProperties(JoinNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_JOIN, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(vertex.getId()), descriptorList, valueMap);
        Constraint[] constraints = vertex.getConstraints();
        if (constraints == null) {
            return;
        }
        int i = 0;
        int length = constraints.length;
        while (i < length) {
            PropertyDescriptor prop = new PropertyDescriptor((Object)(CONSTRAINT + (i + 1)), "Constraint " + (i + 1));
            this.addOther((IPropertyDescriptor)prop, constraints[i].toString(), descriptorList, valueMap);
            ++i;
        }
    }

    private void initNotNodeProperties(NotNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_NOT, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(vertex.getId()), descriptorList, valueMap);
    }

    private void initEvalConditionNodeProperties(EvalConditionNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_EVAL_CONDITION, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(vertex.getId()), descriptorList, valueMap);
    }

    private void initTerminalNodeProperties(RuleTerminalNodeVertex node, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_TERMINAL, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(node.getId()), descriptorList, valueMap);
        this.addProperty(this.PROP_RULE, node.getRuleName(), descriptorList, valueMap);
    }

    private void initQueryTerminalNodeProperties(QueryTerminalNodeVertex node, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_QUERY_TERMINAL, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(node.getId()), descriptorList, valueMap);
        this.addProperty(this.PROP_QUERY, node.getQueryName(), descriptorList, valueMap);
    }

    private void initPropagationQueuingNodeProperties(PropagationQueuingNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_PROPAGATION_QUEUING, descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(vertex.getId()), descriptorList, valueMap);
    }

    private void initEntryPointNodeProperties(EntryPointNodeVertex vertex, List descriptorList, Map valueMap) {
        this.addProperty(this.PROP_NAME, VERTEX_ENTRY_POINT, descriptorList, valueMap);
        this.addProperty(this.PROP_ENTRY_POINT_NAME, vertex.getEntryPointName(), descriptorList, valueMap);
        this.addProperty(this.PROP_ID, Integer.toString(vertex.getId()), descriptorList, valueMap);
    }

    private void addProperty(IPropertyDescriptor field, String value, List descriptorList, Map valueMap) {
        descriptorList.add(field);
        valueMap.put(field.getId().toString(), new NodeValue(CAT_GENERAL, value));
        if (field instanceof PropertyDescriptor) {
            ((PropertyDescriptor)field).setAlwaysIncompatible(true);
            ((PropertyDescriptor)field).setCategory(CAT_GENERAL);
        }
    }

    private void addOther(IPropertyDescriptor field, String value, List descriptorList, Map valueMap) {
        descriptorList.add(field);
        valueMap.put(field.getId().toString(), new NodeValue(CAT_OTHER, value));
        if (field instanceof PropertyDescriptor) {
            ((PropertyDescriptor)field).setAlwaysIncompatible(true);
            ((PropertyDescriptor)field).setCategory(CAT_OTHER);
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public Object getPropertyValue(Object propName) {
        return this.getPropertyValue((String)propName);
    }

    public Object getPropertyValue(String propName) {
        return ((NodeValue)this.values.get((Object)propName)).value;
    }

    public void setPropertyValue(Object propName, Object value) {
        this.setPropertyValue(propName, value);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public void resetPropertyValue(Object propName) {
    }

    public boolean isPropertySet(Object propName) {
        return this.values.containsKey(propName);
    }

    private class NodeValue {
        final String category;
        final String value;

        NodeValue(String category, String value) {
            this.category = category;
            this.value = value;
        }
    }
}

