/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.utils;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.ResourceHistorySorter;
import org.guvnor.tools.views.ResourceHistoryContentProvider;
import org.guvnor.tools.views.ResourceHistoryLabelProvider;
import org.guvnor.tools.views.model.ResourceHistoryEntry;

public class VersionChooserDialog
extends TitleAreaDialog {
    private static final int INITIAL_WIDTH = 790;
    private static final int INITIAL_HEIGHT = 350;
    private String fileName;
    private ResourceHistoryEntry[] entries;
    private ResourceHistoryEntry selectedEntry;
    private TableViewer viewer;

    public VersionChooserDialog(Shell parentShell, String fileName, ResourceHistoryEntry[] entries) {
        super(parentShell);
        super.setShellStyle(this.getShellStyle() | 0x10);
        this.entries = entries;
        this.fileName = fileName;
    }

    protected Control createDialogArea(Composite parent) {
        super.setTitle(Messages.getString("version.dialog.caption"));
        super.setMessage(MessageFormat.format(Messages.getString("version.dialog.message"), this.fileName));
        super.setTitleImage(Activator.getImageDescriptor("guvnor_rep_wizban.gif").createImage());
        this.viewer = new TableViewer(PlatformUtils.createResourceHistoryTable(parent));
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ResourceHistoryContentProvider(this.entries));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceHistoryLabelProvider());
        this.viewer.setSorter((ViewerSorter)new ResourceHistorySorter());
        this.viewer.setInput((Object)this);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                if (VersionChooserDialog.this.viewer.getSelection() instanceof IStructuredSelection && (sel = (IStructuredSelection)VersionChooserDialog.this.viewer.getSelection()).getFirstElement() instanceof ResourceHistoryEntry) {
                    VersionChooserDialog.this.selectedEntry = (ResourceHistoryEntry)sel.getFirstElement();
                }
            }
        });
        if (this.entries.length > 0) {
            this.viewer.getTable().setSelection(0);
            this.selectedEntry = this.entries[0];
        }
        return super.createDialogArea(parent);
    }

    protected Point getInitialSize() {
        return new Point(790, 350);
    }

    public ResourceHistoryEntry getSelectedEntry() {
        return this.selectedEntry;
    }
}

