/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Element;

public class LockEntry
extends ElementEditor {
    protected static final String[] childNames = new String[]{"lockscope", "locktype"};

    public LockEntry(Element root) throws MalformedElementException {
        super(root, "lockentry");
    }

    public boolean isShared() throws MalformedElementException {
        Element lockscope = LockEntry.getFirstChild(this.root, "lockscope");
        LockEntry.ensureNotNull(Policy.bind("ensure.missingLockscopeElmt"), lockscope);
        String[] names = new String[]{"shared", "exclusive"};
        Element sharedOrExclusive = LockEntry.getFirstChild(lockscope, names);
        LockEntry.ensureNotNull(Policy.bind("ensure.missingSharedOrExclusiveElmt"), sharedOrExclusive);
        boolean isShared = LockEntry.isDAVElement(sharedOrExclusive, "shared");
        LockEntry.ensure(LockEntry.getNextSibling(sharedOrExclusive, names) == null, Policy.bind("ensure.conflictingSharedOrExclusiveElmt"));
        return isShared;
    }

    public void setIsShared(boolean isShared) {
        Element lockscope = LockEntry.setChild(this.root, "lockscope", childNames, true);
        if (isShared) {
            LockEntry.appendChild(lockscope, "shared");
        } else {
            LockEntry.appendChild(lockscope, "exclusive");
        }
    }
}

