/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.jbpm.eclipse.JBPMEclipsePlugin;

public class ProjectClassLoader {
    public static URLClassLoader getProjectClassLoader(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ProjectClassLoader.getProjectClassLoader(((IFileEditorInput)input).getFile());
        }
        return null;
    }

    public static URLClassLoader getProjectClassLoader(IFile file) {
        IProject project = file.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return ProjectClassLoader.getProjectClassLoader(javaProject);
    }

    public static URLClassLoader getProjectClassLoader(IJavaProject project) {
        List<URL> pathElements = ProjectClassLoader.getProjectClassPathURLs(project, new ArrayList<String>());
        URL[] urlPaths = pathElements.toArray(new URL[pathElements.size()]);
        return new URLClassLoader(urlPaths, Thread.currentThread().getContextClassLoader());
    }

    private static URL getRawLocationURL(IPath simplePath) throws MalformedURLException {
        File file = ProjectClassLoader.getRawLocationFile(simplePath);
        return file.toURI().toURL();
    }

    private static File getRawLocationFile(IPath simplePath) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(simplePath);
        File file = null;
        file = resource != null ? ResourcesPlugin.getWorkspace().getRoot().findMember(simplePath).getRawLocation().toFile() : simplePath.toFile();
        return file;
    }

    public static List<URL> getProjectClassPathURLs(IJavaProject project, List<String> alreadyLoadedProjects) {
        ArrayList<URL> pathElements = new ArrayList<URL>();
        try {
            IClasspathEntry[] paths = project.getResolvedClasspath(true);
            HashSet<IPath> outputPaths = new HashSet<IPath>();
            if (paths != null) {
                int i = 0;
                while (i < paths.length) {
                    IClasspathEntry path = paths[i];
                    if (path.getEntryKind() == 1) {
                        URL url = ProjectClassLoader.getRawLocationURL(path.getPath());
                        pathElements.add(url);
                    } else if (path.getEntryKind() == 3) {
                        IPath output = path.getOutputLocation();
                        if (path.getOutputLocation() != null) {
                            outputPaths.add(output);
                        }
                    }
                    ++i;
                }
            }
            IPath location = ProjectClassLoader.getProjectLocation(project.getProject());
            IPath outputPath = location.append(project.getOutputLocation().removeFirstSegments(1));
            pathElements.add(0, outputPath.toFile().toURI().toURL());
            for (IPath path : outputPaths) {
                outputPath = location.append(path.removeFirstSegments(1));
                pathElements.add(0, outputPath.toFile().toURI().toURL());
            }
            String[] stringArray = project.getRequiredProjectNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName = stringArray[n2];
                if (!alreadyLoadedProjects.contains(projectName)) {
                    alreadyLoadedProjects.add(projectName);
                    IProject reqProject = project.getProject().getWorkspace().getRoot().getProject(projectName);
                    if (reqProject != null) {
                        IJavaProject reqJavaProject = JavaCore.create((IProject)reqProject);
                        pathElements.addAll(ProjectClassLoader.getProjectClassPathURLs(reqJavaProject, alreadyLoadedProjects));
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JBPMEclipsePlugin.log(e);
        }
        catch (MalformedURLException e) {
            JBPMEclipsePlugin.log(e);
        }
        catch (Throwable t) {
            JBPMEclipsePlugin.log(t);
        }
        return pathElements;
    }

    public static IPath getProjectLocation(IProject project) {
        if (project.getRawLocation() == null) {
            return project.getLocation();
        }
        return project.getRawLocation();
    }
}

