/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class DSLMappingSorter
extends ViewerSorter {
    public static final int OBJECT = 0;
    public static final int EXPRESSION = 1;
    public static final int MAPPING = 2;
    public static final int SCOPE = 3;
    private int criteria;

    public DSLMappingSorter(int criteria) {
        this.criteria = criteria;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        DSLMappingEntry item1 = (DSLMappingEntry)o1;
        DSLMappingEntry item2 = (DSLMappingEntry)o2;
        switch (this.criteria) {
            case 0: {
                return this.compareObject(item1, item2);
            }
            case 1: {
                return this.compareExpressions(item1, item2);
            }
            case 2: {
                return this.compareMappings(item1, item2);
            }
            case 3: {
                return this.compareScope(item1, item2);
            }
        }
        return 0;
    }

    private int compareScope(DSLMappingEntry item1, DSLMappingEntry item2) {
        return item1.getSection().compareTo((Enum)item2.getSection());
    }

    private int compareMappings(DSLMappingEntry item1, DSLMappingEntry item2) {
        return item1.getMappingValue().compareTo(item2.getMappingValue());
    }

    private int compareExpressions(DSLMappingEntry item1, DSLMappingEntry item2) {
        return item1.getMappingKey().compareTo(item2.getMappingKey());
    }

    private int compareObject(DSLMappingEntry item1, DSLMappingEntry item2) {
        return item1.getMetaData().compareTo((Object)item2.getMetaData());
    }

    public int getCriteria() {
        return this.criteria;
    }
}

