/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.eclipse.draw2d.geometry.Point;

public abstract class ElementConnection
implements Serializable {
    private static final long serialVersionUID = 510L;
    public static final int CHANGE_BENDPOINTS = 1;
    public static final int CHANGE_LABEL = 2;
    private ElementWrapper source;
    private ElementWrapper target;
    private transient List<Point> bendpoints = new ArrayList<Point>();
    private transient List<ModelListener> listeners = new ArrayList<ModelListener>();

    public void localSetSource(ElementWrapper source) {
        this.source = source;
    }

    public void localSetTarget(ElementWrapper target) {
        this.target = target;
    }

    public void disconnect() {
        if (this.source == null) {
            throw new IllegalStateException("Can't disconnect, source is null");
        }
        if (this.target == null) {
            throw new IllegalStateException("Can't disconnect, target is null");
        }
        this.source.removeOutgoingConnection(this);
        this.target.removeIncomingConnection(this);
        this.source = null;
        this.target = null;
    }

    public void connect(ElementWrapper source, ElementWrapper target) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (this.source != null) {
            throw new IllegalStateException("The source of a connection cannot be changed");
        }
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (this.target != null) {
            throw new IllegalStateException("The target of a connection cannot be changed");
        }
        this.source = source;
        this.target = target;
        source.addOutgoingConnection(this);
        target.addIncomingConnection(this);
    }

    public ElementWrapper getSource() {
        return this.source;
    }

    public ElementWrapper getTarget() {
        return this.target;
    }

    public void addBendpoint(int index, Point point) {
        this.bendpoints.add(index, point);
        this.internalSetBendpoints(this.bendpoints);
        this.notifyListeners(1);
    }

    public void removeBendpoint(int index) {
        this.bendpoints.remove(index);
        this.internalSetBendpoints(this.bendpoints);
        this.notifyListeners(1);
    }

    public void replaceBendpoint(int index, Point point) {
        this.bendpoints.set(index, point);
        this.internalSetBendpoints(this.bendpoints);
        this.notifyListeners(1);
    }

    protected void internalSetBendpoints(List<Point> bendPoints) {
    }

    public void localSetBendpoints(List<Point> bendpoints) {
        this.bendpoints = bendpoints;
    }

    public List<Point> getBendpoints() {
        if (this.bendpoints == null) {
            this.bendpoints = this.internalGetBendpoints();
        }
        return this.bendpoints;
    }

    protected abstract List<Point> internalGetBendpoints();

    public void addListener(ModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(int change) {
        ModelEvent event = new ModelEvent(change);
        for (ModelListener listener : this.listeners) {
            listener.modelChanged(event);
        }
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.listeners = new ArrayList<ModelListener>();
    }
}

