/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.io.IOException;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.AbstractResourceHandle;
import org.eclipse.webdav.client.CollectionHandle;
import org.eclipse.webdav.client.DAVClient;
import org.eclipse.webdav.dom.Mkworkspace;
import org.eclipse.webdav.internal.kernel.DAVException;
import org.eclipse.webdav.internal.kernel.SystemException;
import org.w3c.dom.Document;

public class WorkspaceHandle
extends CollectionHandle {
    public WorkspaceHandle(DAVClient davClient, ILocator locator) {
        super(davClient, locator);
    }

    @Override
    public AbstractResourceHandle checkOut() throws DAVException {
        ILocator locator = this.protectedCheckOut();
        return new WorkspaceHandle(this.davClient, locator);
    }

    @Override
    public void create() throws DAVException {
        Document document = this.newDocument();
        Mkworkspace.create(document);
        IResponse response = null;
        try {
            try {
                response = this.davClient.mkworkspace(this.locator, this.newContext(), document);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
        this.closeResponse(response);
    }
}

