/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.repository;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.Activator;
import org.kie.eclipse.server.IKieServerHandler;

public class KieCredentialsProvider
extends CredentialsProvider {
    private IKieServerHandler server;
    private String user;
    private String password;

    public KieCredentialsProvider(IKieServerHandler server, String username, String password) {
        this.server = server;
        this.user = username;
        this.password = password;
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (!(i instanceof CredentialItem.Username) && !(i instanceof CredentialItem.Password)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        if (items.length == 0) {
            return true;
        }
        CredentialItem.Username userItem = null;
        CredentialItem.Password passwordItem = null;
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            final CredentialItem item = credentialItemArray[n2];
            System.out.println("Credentials.get: " + item.getPromptText());
            if (item instanceof CredentialItem.Username) {
                userItem = (CredentialItem.Username)item;
            } else if (item instanceof CredentialItem.Password) {
                passwordItem = (CredentialItem.Password)item;
            } else {
                if (item instanceof CredentialItem.YesNoType) {
                    String trustedConnection = this.server.getPreference("ServerTrustedConnection", "never");
                    final AtomicReference<Boolean> ar = new AtomicReference<Boolean>();
                    if ("always".equals(trustedConnection)) {
                        ar.set(true);
                    } else {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Connect to Server", (String)item.getPromptText(), (String)"Don't ask me again", (boolean)false, (IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)KieCredentialsProvider.this.server.getPreferenceName("ServerTrustedConnection"));
                                ar.set(dlg.getReturnCode() == 2);
                                if (((Boolean)ar.get()).booleanValue()) {
                                    KieCredentialsProvider.this.server.putPreference("ServerTrustedConnection", dlg.getToggleState() ? "always" : "never");
                                }
                            }
                        });
                    }
                    ((CredentialItem.YesNoType)item).setValue(((Boolean)ar.get()).booleanValue());
                    return true;
                }
                throw new UnsupportedCredentialItem(uri, "Credential Item not supported : " + item.getPromptText());
            }
            ++n2;
        }
        if (userItem != null || passwordItem != null) {
            UserPasswordCredentials credentials = null;
            if (this.user != null && this.password != null) {
                credentials = new UserPasswordCredentials(this.user, this.password);
            }
            if (credentials == null) {
                return false;
            }
            if (userItem != null) {
                userItem.setValue(credentials.getUser());
            }
            if (passwordItem != null) {
                passwordItem.setValue(credentials.getPassword().toCharArray());
            }
            return true;
        }
        return false;
    }
}

