/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.project;

import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NewDroolsProjectRuntimeWizardPage
extends WizardPage {
    public static final String DROOLS4 = "Drools 4.x";
    public static final String DROOLS5 = "Drools 5.0.x";
    public static final String DROOLS5_1 = "Drools 5.1.x or above";
    public static final String DROOLS6 = "Drools 6.0.x";
    private boolean isDefaultRuntime = true;
    private String selectedRuntime;
    private String generationType = "Drools 6.0.x";
    private Button projectSpecificRuntime;
    private Combo droolsRuntimeCombo;
    private Combo droolsGenerateCombo;
    private Composite gavPanel;
    private String groupId = "";
    private String artifactId = "";
    private String version = "";

    public NewDroolsProjectRuntimeWizardPage() {
        super("extendedNewProjectRuntimePage");
        this.setTitle("Drools Runtime");
        this.setDescription("Select a Drools Runtime");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        DroolsRuntime defaultRuntime = DroolsRuntimeManager.getDefaultDroolsRuntime();
        this.projectSpecificRuntime = this.createCheckBox(composite, "Use default Drools Runtime (currently " + (defaultRuntime == null ? "undefined)" : String.valueOf(defaultRuntime.getName()) + ")"));
        this.projectSpecificRuntime.setSelection(true);
        this.projectSpecificRuntime.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewDroolsProjectRuntimeWizardPage.this.isDefaultRuntime = ((Button)e.widget).getSelection();
                NewDroolsProjectRuntimeWizardPage.this.droolsRuntimeCombo.setEnabled(!NewDroolsProjectRuntimeWizardPage.this.isDefaultRuntime);
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.projectSpecificRuntime.setLayoutData((Object)gridData);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Drools Runtime:");
        this.droolsRuntimeCombo = new Combo(composite, 8);
        this.droolsRuntimeCombo.setEnabled(false);
        this.droolsRuntimeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewDroolsProjectRuntimeWizardPage.this.selectedRuntime = NewDroolsProjectRuntimeWizardPage.this.droolsRuntimeCombo.getText();
            }

            public void widgetSelected(SelectionEvent e) {
                NewDroolsProjectRuntimeWizardPage.this.selectedRuntime = NewDroolsProjectRuntimeWizardPage.this.droolsRuntimeCombo.getText();
            }
        });
        DroolsRuntime[] runtimes = DroolsRuntimeManager.getDroolsRuntimes();
        if (runtimes.length == 0) {
            this.setErrorMessage("No Drools Runtimes have been defined, configure workspace settings first");
        } else {
            this.setErrorMessage(null);
            int i = 0;
            while (i < runtimes.length) {
                this.droolsRuntimeCombo.add(runtimes[i].getName());
                ++i;
            }
            this.droolsRuntimeCombo.select(0);
            this.selectedRuntime = this.droolsRuntimeCombo.getText();
        }
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.droolsRuntimeCombo.setLayoutData((Object)gridData);
        Link changeWorkspaceSettingsLink = this.createLink(composite, "Configure Workspace Settings...");
        changeWorkspaceSettingsLink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Composite subPanel = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        subPanel.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        subPanel.setLayoutData((Object)gridData);
        Label generateLabel = new Label(subPanel, 0);
        generateLabel.setText("Generate code compatible with:");
        this.droolsGenerateCombo = new Combo(subPanel, 8);
        this.droolsGenerateCombo.add(DROOLS4);
        this.droolsGenerateCombo.add(DROOLS5);
        this.droolsGenerateCombo.add(DROOLS5_1);
        this.droolsGenerateCombo.add(DROOLS6);
        this.droolsGenerateCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewDroolsProjectRuntimeWizardPage.this.generationType = NewDroolsProjectRuntimeWizardPage.this.droolsGenerateCombo.getText();
                NewDroolsProjectRuntimeWizardPage.this.gavPanel.setVisible(NewDroolsProjectRuntimeWizardPage.this.getGenerationType().equals(NewDroolsProjectRuntimeWizardPage.DROOLS6));
                NewDroolsProjectRuntimeWizardPage.this.setComplete();
            }

            public void widgetSelected(SelectionEvent e) {
                NewDroolsProjectRuntimeWizardPage.this.generationType = NewDroolsProjectRuntimeWizardPage.this.droolsGenerateCombo.getText();
                NewDroolsProjectRuntimeWizardPage.this.gavPanel.setVisible(NewDroolsProjectRuntimeWizardPage.this.getGenerationType().equals(NewDroolsProjectRuntimeWizardPage.DROOLS6));
                NewDroolsProjectRuntimeWizardPage.this.setComplete();
            }
        });
        this.droolsGenerateCombo.select(3);
        this.setPageComplete(false);
        this.generationType = DROOLS6;
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.droolsGenerateCombo.setLayoutData((Object)gridData);
        this.gavPanel = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.gavPanel.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.gavPanel.setLayoutData((Object)gridData);
        Label groupLabel = new Label(this.gavPanel, 0);
        groupLabel.setText("GroupId: ");
        final Text groupField = new Text(this.gavPanel, 2048);
        groupField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewDroolsProjectRuntimeWizardPage.this.groupId = groupField.getText();
                NewDroolsProjectRuntimeWizardPage.this.setComplete();
            }
        });
        Label artifactLabel = new Label(this.gavPanel, 0);
        artifactLabel.setText("ArtifactId: ");
        final Text artifactField = new Text(this.gavPanel, 2048);
        artifactField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewDroolsProjectRuntimeWizardPage.this.artifactId = artifactField.getText();
                NewDroolsProjectRuntimeWizardPage.this.setComplete();
            }
        });
        Label versionLabel = new Label(this.gavPanel, 0);
        versionLabel.setText("Version: ");
        final Text versionField = new Text(this.gavPanel, 2048);
        versionField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewDroolsProjectRuntimeWizardPage.this.version = versionField.getText();
                NewDroolsProjectRuntimeWizardPage.this.setComplete();
            }
        });
        this.setMessage(null);
        this.setPageComplete(runtimes.length > 0 && this.isComplete());
        this.setControl((Control)composite);
    }

    private void setComplete() {
        this.setPageComplete(this.isComplete());
    }

    private boolean isComplete() {
        return !this.getGenerationType().equals(DROOLS6) || this.getGroupId().length() > 0 && this.getArtifactId().length() > 0 && this.getVersion().length() > 0;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewDroolsProjectRuntimeWizardPage.this.openLink();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewDroolsProjectRuntimeWizardPage.this.openLink();
            }
        });
        return link;
    }

    private void openLink() {
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.drools.eclipse.preferences.DroolsRuntimesPreferencePage", (String[])new String[]{"org.drools.eclipse.preferences.DroolsProjectPreferencePage"}, null).open();
        this.droolsRuntimeCombo.removeAll();
        DroolsRuntime[] runtimes = DroolsRuntimeManager.getDroolsRuntimes();
        if (runtimes.length == 0) {
            this.setPageComplete(false);
            this.setErrorMessage("No Drools Runtimes have been defined, please do this first");
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            int i = 0;
            while (i < runtimes.length) {
                this.droolsRuntimeCombo.add(runtimes[i].getName());
                ++i;
            }
            this.droolsRuntimeCombo.select(0);
            this.selectedRuntime = this.droolsRuntimeCombo.getText();
        }
        DroolsRuntime defaultRuntime = DroolsRuntimeManager.getDefaultDroolsRuntime();
        this.projectSpecificRuntime.setText("Use default Drools Runtime (currently " + (defaultRuntime == null ? "undefined)" : String.valueOf(defaultRuntime.getName()) + ")"));
    }

    public DroolsRuntime getDroolsRuntime() {
        if (this.isDefaultRuntime) {
            return null;
        }
        return DroolsRuntimeManager.getDroolsRuntime(this.selectedRuntime);
    }

    public String getGenerationType() {
        return this.generationType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }
}

