/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.content;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jgit.lib.Repository;
import org.kie.eclipse.navigator.view.content.ContainerNode;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.content.OrganizationNode;
import org.kie.eclipse.navigator.view.content.ProjectNode;
import org.kie.eclipse.navigator.view.content.ServerNode;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.utils.GitUtils;

public class RepositoryNode
extends ContainerNode<OrganizationNode>
implements IEclipsePreferences.IPreferenceChangeListener {
    protected RepositoryNode(OrganizationNode parent, IKieRepositoryHandler repository) {
        super(parent, (IKieResourceHandler)repository);
        this.init();
    }

    protected RepositoryNode(ServerNode parent, IKieRepositoryHandler repository) {
        super(null, (IKieResourceHandler)repository);
        this.parent = parent;
        this.init();
    }

    private void init() {
        GitUtils.getRepositoryUtil().getPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    @Override
    protected List<? extends IContentNode<?>> createChildren() {
        this.clearHandlerChildren();
        this.load();
        ArrayList<ProjectNode> children = new ArrayList<ProjectNode>();
        for (IKieResourceHandler h : this.handlerChildren) {
            if (!(h instanceof IKieProjectHandler)) continue;
            children.add(new ProjectNode(this, (IKieProjectHandler)h));
        }
        return children;
    }

    @Override
    public Object getAdapter(Class adapter) {
        Object o;
        if (adapter == Repository.class && (o = this.getHandler().getResource()) instanceof Repository) {
            return o;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void dispose() {
        GitUtils.getRepositoryUtil().getPreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        this.getParent().clearChildren();
        this.refresh();
    }
}

