/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.wizard.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.wizard.project.IKieEmptyProjectWizardPage;
import org.kie.eclipse.wizard.project.KieProjectWizardPage;

public abstract class AbstractKieEmptyProjectWizardPage
extends KieProjectWizardPage
implements IKieEmptyProjectWizardPage {
    protected IRuntimeManager runtimeManager;
    private List<IRuntime> runtimes = new ArrayList<IRuntime>();
    private boolean isDefaultRuntime = true;
    private IRuntime selectedRuntime;
    private IRuntime effectiveRuntime;
    private Button projectSpecificRuntime;
    private Combo runtimesCombo;
    private boolean createMavenProject = true;
    private boolean createKJarProject = true;

    protected abstract void createControls(Composite var1);

    @Override
    public abstract IRuntimeManager getRuntimeManager();

    protected abstract IRuntime createRuntime();

    public abstract int showRuntimePreferenceDialog();

    public AbstractKieEmptyProjectWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Create an Empty Project");
        this.runtimeManager = this.getRuntimeManager();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createRuntimeControls((Composite)this.getControl());
        this.createKJarControls((Composite)this.getControl());
        this.createControls((Composite)this.getControl());
    }

    protected Composite createRuntimeControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        this.projectSpecificRuntime = new Button(composite, 32);
        this.projectSpecificRuntime.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.projectSpecificRuntime.setSelection(this.isDefaultRuntime);
        this.projectSpecificRuntime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractKieEmptyProjectWizardPage.this.isDefaultRuntime = ((Button)e.widget).getSelection();
                AbstractKieEmptyProjectWizardPage.this.runtimesCombo.setEnabled(!AbstractKieEmptyProjectWizardPage.this.isDefaultRuntime);
            }
        });
        Label nameLabel = new Label(composite, 0);
        nameLabel.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        nameLabel.setText("Use Runtime:");
        this.runtimesCombo = new Combo(composite, 8);
        this.runtimesCombo.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.runtimesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Integer key = AbstractKieEmptyProjectWizardPage.this.runtimesCombo.getSelectionIndex();
                IRuntime rt = (IRuntime)AbstractKieEmptyProjectWizardPage.this.runtimesCombo.getData(key.toString());
                if (rt != AbstractKieEmptyProjectWizardPage.this.selectedRuntime) {
                    AbstractKieEmptyProjectWizardPage.this.selectedRuntime = rt;
                    AbstractKieEmptyProjectWizardPage.this.effectiveRuntime = null;
                }
                AbstractKieEmptyProjectWizardPage.this.setPageComplete(AbstractKieEmptyProjectWizardPage.this.isPageComplete());
            }
        });
        Link changeWorkspaceSettingsLink = new Link(composite, 0);
        changeWorkspaceSettingsLink.setLayoutData((Object)new GridData(3, 2, true, false, 1, 1));
        changeWorkspaceSettingsLink.setText("<A>Change Workspace Settings...</A>");
        changeWorkspaceSettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractKieEmptyProjectWizardPage.this.showRuntimePreferenceDialog() == 0) {
                    AbstractKieEmptyProjectWizardPage.this.fillRuntimesCombo();
                }
            }
        });
        this.fillRuntimesCombo();
        return composite;
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.runtimes.size() > 0;
    }

    protected Composite createKJarControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.verticalIndent = 10;
        gd.horizontalIndent = 16;
        composite.setLayoutData((Object)gd);
        final Button createMavenProjectButton = new Button(composite, 32);
        createMavenProjectButton.setText("Create as Maven Project");
        createMavenProjectButton.setToolTipText("Generates a default Maven \"Project Object Model\" (POM) File");
        createMavenProjectButton.setSelection(this.createMavenProject);
        final Button createKJarProjectButton = new Button(composite, 32);
        createKJarProjectButton.setText("Create as KJar Project");
        createKJarProjectButton.setToolTipText("Generates a default KJar Module Descriptor as well as the necessary Maven artifacts");
        createKJarProjectButton.setSelection(this.createKJarProject);
        createMavenProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractKieEmptyProjectWizardPage.this.createMavenProject = createMavenProjectButton.getSelection();
            }
        });
        createKJarProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractKieEmptyProjectWizardPage.this.createKJarProject = createKJarProjectButton.getSelection();
                if (AbstractKieEmptyProjectWizardPage.this.createKJarProject) {
                    createMavenProjectButton.setSelection(true);
                    createMavenProjectButton.setEnabled(false);
                } else {
                    createMavenProjectButton.setEnabled(true);
                }
            }
        });
        return composite;
    }

    @Override
    public boolean shouldCreateMavenProject() {
        return this.createMavenProject;
    }

    @Override
    public boolean shouldCreateKJarProject() {
        return this.createKJarProject;
    }

    private void fillRuntimesCombo() {
        IRuntime rt;
        this.runtimes.clear();
        IRuntime[] iRuntimeArray = this.runtimeManager.getConfiguredRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            rt = iRuntimeArray[n2];
            this.runtimes.add(rt);
            ++n2;
        }
        if (this.runtimeManager.getDefaultRuntime() == null) {
            this.isDefaultRuntime = false;
        }
        if (this.runtimes.size() == 0) {
            rt = this.createRuntime();
            rt.setName(this.runtimeManager.getBundleRuntimeName());
            rt.setVersion(this.runtimeManager.getBundleRuntimeVersion());
            rt.setDefault(true);
            this.runtimes.add(rt);
            this.setControlVisible((Control)this.runtimesCombo, true);
            this.isDefaultRuntime = true;
        }
        this.runtimesCombo.setEnabled(!this.isDefaultRuntime);
        this.setErrorMessage(null);
        this.runtimesCombo.removeAll();
        Integer key = 0;
        for (IRuntime rt2 : this.runtimes) {
            String name = rt2.getName();
            if (rt2.getPath() == null) {
                name = String.valueOf(name) + " (will be created)";
            }
            this.runtimesCombo.add(name);
            this.runtimesCombo.setData(key.toString(), (Object)rt2);
            key = key + 1;
        }
        key = 0;
        this.runtimesCombo.select(key.intValue());
        this.selectedRuntime = (IRuntime)this.runtimesCombo.getData(key.toString());
        IRuntime defaultRuntime = this.runtimeManager.getDefaultRuntime();
        if (defaultRuntime == null && this.runtimes.size() == 1) {
            defaultRuntime = this.runtimes.get(0);
        }
        this.projectSpecificRuntime.setText("Use default Runtime (" + (defaultRuntime == null ? "undefined)" : String.valueOf(defaultRuntime.getName()) + ")"));
        this.projectSpecificRuntime.setEnabled(this.isDefaultRuntime);
    }

    @Override
    public IRuntime getRuntime() {
        if (this.effectiveRuntime == null) {
            this.effectiveRuntime = this.runtimeManager.getEffectiveRuntime(this.selectedRuntime, this.isDefaultRuntime);
        }
        return this.effectiveRuntime;
    }

    @Override
    public boolean isDefaultRuntime() {
        return this.isDefaultRuntime;
    }

    public IWizardPage getNextPage() {
        return null;
    }
}

