/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.eclipse.navigator.view.content.ContentNode;
import org.kie.eclipse.navigator.view.content.ErrorNode;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.content.IErrorNode;
import org.kie.eclipse.server.IKieResourceHandler;

public abstract class ContainerNode<T extends IContainerNode<?>>
extends ContentNode<T>
implements IContainerNode<T> {
    private IErrorNode error;
    protected List<? extends IKieResourceHandler> handlerChildren;
    protected List<? extends IContentNode<?>> children;

    protected ContainerNode(String name) {
        super(name);
    }

    protected ContainerNode(T parent, IKieResourceHandler handler) {
        super(parent, handler);
    }

    @Override
    public boolean hasChildren() {
        return this.isResolved();
    }

    @Override
    public List<? extends IContentNode<?>> getChildren() {
        if (this.error != null) {
            return Collections.singletonList(this.error);
        }
        if (this.handlerChildren != null) {
            String internalRefresh = this.getNavigator().getProperty("org.kie.eclipse.navigator.property.internalRefresh");
            if (this.children == null || Boolean.getBoolean(internalRefresh)) {
                this.children = ContainerNode.updateChildren(this.children, this.createChildren());
            }
            return this.children;
        }
        return null;
    }

    protected abstract List<? extends IContentNode<?>> createChildren();

    @Override
    public final void clearChildren() {
        this.clearError();
        this.clearHandlerChildren();
        if (this.children != null) {
            for (IContentNode<?> n : this.children) {
                n.dispose();
            }
            this.children.clear();
            this.children = null;
        }
    }

    public final void clearHandlerChildren() {
        if (this.handlerChildren != null) {
            for (IKieResourceHandler iKieResourceHandler : this.handlerChildren) {
                iKieResourceHandler.dispose();
            }
            this.handlerChildren.clear();
            this.handlerChildren = null;
        }
    }

    protected void setError(IErrorNode error) {
        this.clearError();
        this.error = error;
    }

    @Override
    public void dispose() {
        this.clearChildren();
        super.dispose();
    }

    @Override
    public final void load() {
        if (this.getServer().getServerState() != 2) {
            this.setError(new ErrorNode(this, "Not connected"));
            return;
        }
        try {
            this.handlerChildren = this.getHandler().getChildren();
            this.clearError();
        }
        catch (Exception e) {
            this.setError(new ErrorNode(this, e));
        }
    }

    public static List<? extends IContentNode<?>> updateChildren(List<? extends IContentNode<?>> children, List<? extends IContentNode<?>> newChildren) {
        if (children == null) {
            children = newChildren;
        } else {
            ArrayList removed = new ArrayList();
            for (IContentNode<?> newChild : newChildren) {
                boolean bl = false;
                for (IContentNode<IContentNode<?>> iContentNode : children) {
                    if (!iContentNode.equals(newChild)) continue;
                    newChild.dispose();
                    bl = true;
                    break;
                }
                if (bl) continue;
                children.add(newChild);
            }
            for (IContentNode<IContentNode<?>> iContentNode : children) {
                boolean found = false;
                for (IContentNode<?> newChild : newChildren) {
                    if (!iContentNode.equals(newChild)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                removed.add(iContentNode);
                iContentNode.dispose();
            }
            children.removeAll(removed);
        }
        Collections.sort(children);
        return children;
    }

    private void clearError() {
        if (this.error != null) {
            this.error.dispose();
            this.error = null;
        }
    }
}

