/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class Locator
implements ILocator {
    protected String resourceURL;
    protected String label;
    protected boolean isStable;

    public Locator(String resourceURL, String label) {
        Assert.isLegal(resourceURL != null);
        this.resourceURL = resourceURL;
        this.label = label;
        this.isStable = false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ILocator)) {
            return false;
        }
        ILocator locator = (ILocator)obj;
        if (!this.resourceURL.equals(locator.getResourceURL())) {
            return false;
        }
        if (this.label == null) {
            return locator.getLabel() == null;
        }
        return this.label.equals(locator.getLabel());
    }

    public int hashCode() {
        return this.resourceURL.hashCode();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getResourceURL() {
        return this.resourceURL;
    }

    @Override
    public boolean isStable() {
        return this.isStable;
    }

    public void markStable() {
        Assert.isTrue(this.label == null);
        this.isStable = true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Locator ");
        buffer.append(this.resourceURL);
        if (this.label != null) {
            buffer.append("\n  label: ");
            buffer.append(this.label);
        }
        if (this.isStable) {
            buffer.append("\n  stable");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

