/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import org.eclipse.webdav.internal.kernel.utils.Assert;

public final class Base64Encoder {
    public static String encode(byte[] data) {
        Assert.isNotNull(data);
        StringBuffer buf = new StringBuffer();
        byte b = 0;
        int bits = 2;
        int i = 0;
        while (i < data.length) {
            b = (byte)((b | data[i] >> bits) & 0x3F);
            buf.append(Base64Encoder.encode(b));
            b = (byte)(data[i] << 6 - bits & 0x3F);
            if ((bits += 2) == 8) {
                buf.append(Base64Encoder.encode((byte)(b & 0x3F)));
                b = 0;
                bits = 2;
            }
            ++i;
        }
        if (bits == 4) {
            buf.append(Base64Encoder.encode(b));
            buf.append("==");
        } else if (bits == 6) {
            buf.append(Base64Encoder.encode(b));
            buf.append('=');
        }
        return buf.toString();
    }

    private static char encode(byte b) {
        if (b >= 0 && b <= 25) {
            return (char)(b + 65);
        }
        if (b >= 26 && b <= 51) {
            return (char)(b + 71);
        }
        if (b >= 52 && b <= 61) {
            return (char)(b - 4);
        }
        if (b == 62) {
            return '+';
        }
        if (b == 63) {
            return '/';
        }
        return '=';
    }
}

