/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.drools.core.audit.WorkingMemoryLog;
import org.drools.core.audit.event.ActivationLogEvent;
import org.drools.core.audit.event.LogEvent;
import org.drools.core.audit.event.ObjectLogEvent;
import org.drools.core.audit.event.RuleBaseLogEvent;
import org.drools.core.audit.event.RuleFlowGroupLogEvent;
import org.drools.core.audit.event.RuleFlowLogEvent;
import org.drools.core.audit.event.RuleFlowNodeLogEvent;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.DroolsPluginImages;
import org.drools.eclipse.debug.AuditViewContentProvider;
import org.drools.eclipse.debug.actions.DeleteLogAction;
import org.drools.eclipse.debug.actions.FileAuditDropAdapter;
import org.drools.eclipse.debug.actions.OpenLogAction;
import org.drools.eclipse.debug.actions.RefreshLogAction;
import org.drools.eclipse.debug.actions.ShowEventCauseAction;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public class AuditView
extends AbstractDebugView {
    private static final String LOG_FILE_NAME = "LogFileName";
    private static final String CAUSE_EVENT_COLOR = "CauseEventColor";
    private String logFileName;
    private IAction deleteAction;
    private IAction refreshAction;
    private boolean drools4 = false;

    protected Viewer createViewer(Composite parent) {
        TreeViewer variablesViewer = new TreeViewer(parent);
        variablesViewer.setContentProvider((IContentProvider)new AuditViewContentProvider());
        variablesViewer.setLabelProvider((IBaseLabelProvider)new AuditLabelProvider());
        variablesViewer.setUseHashlookup(true);
        variablesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AuditView.this.getViewer().refresh();
            }
        });
        int ops = 3;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        variablesViewer.addDropSupport(ops, transfers, (DropTargetListener)new FileAuditDropAdapter((Viewer)variablesViewer, this));
        return variablesViewer;
    }

    public void setLogFile(String logFileName) {
        this.logFileName = logFileName;
        this.refresh();
        this.deleteAction.setEnabled(logFileName != null);
        this.refreshAction.setEnabled(logFileName != null);
    }

    public void refresh() {
        this.drools4 = false;
        boolean reteoo = false;
        if (this.logFileName == null) {
            this.getViewer().setInput(null);
            return;
        }
        ArrayList<LogEvent> eventList = new ArrayList<LogEvent>();
        try {
            XStream xstream = new XStream();
            ObjectInputStream in = xstream.createObjectInputStream((Reader)new FileReader(this.logFileName));
            try {
                Object object;
                while (true) {
                    if ((object = in.readObject()) instanceof WorkingMemoryLog) {
                        WorkingMemoryLog log = (WorkingMemoryLog)object;
                        eventList.addAll(log.getEvents());
                        reteoo |= this.isReteoo(log);
                        continue;
                    }
                    if (object instanceof LogEvent) {
                        eventList.add((LogEvent)object);
                        continue;
                    }
                    if (!(object instanceof List)) break;
                    this.drools4 = true;
                    eventList.addAll((List)object);
                }
                throw new IllegalArgumentException("Unexpected element in log: " + object);
            }
            catch (StreamException e) {
                if (!(e.getCause() instanceof EOFException)) {
                    throw e;
                }
            }
            catch (EOFException eOFException) {
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setLogFile(null);
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
        if (reteoo) {
            this.getViewer().setInput(this.createEventList(eventList));
        } else if (this.drools4) {
            this.getViewer().setInput(this.createDrools4EventList(eventList));
        } else {
            this.getViewer().setInput(this.createPhreakEventList(eventList));
        }
        ((TreeViewer)this.getViewer()).expandAll();
    }

    private boolean isReteoo(WorkingMemoryLog log) {
        try {
            Method m = log.getClass().getMethod("getEngine", new Class[0]);
            return ((String)m.invoke((Object)log, new Object[0])).equalsIgnoreCase("RETEOO");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    protected List<Event> createPhreakEventList(List<LogEvent> logEvents) {
        HashMap<Long, Event> objectMap = new HashMap<Long, Event>();
        HashMap<String, Event> activationMap = new HashMap<String, Event>();
        Stack<Event> beforeEvents = new Stack<Event>();
        ArrayList<Event> events = new ArrayList<Event>();
        for (LogEvent logEvent : logEvents) {
            Event event = new Event(logEvent.getType());
            switch (logEvent.getType()) {
                case 1: {
                    ObjectLogEvent objectEvent = (ObjectLogEvent)logEvent;
                    event.setString("Object inserted (" + objectEvent.getFactId() + "): " + objectEvent.getObjectToString());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    objectMap.put(objectEvent.getFactId(), event);
                    break;
                }
                case 2: {
                    ObjectLogEvent objectEvent = (ObjectLogEvent)logEvent;
                    event.setString("Object updated (" + objectEvent.getFactId() + "): " + objectEvent.getObjectToString());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    objectMap.put(objectEvent.getFactId(), event);
                    break;
                }
                case 3: {
                    ObjectLogEvent objectEvent = (ObjectLogEvent)logEvent;
                    event.setString("Object removed (" + objectEvent.getFactId() + "): " + objectEvent.getObjectToString());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    objectMap.put(objectEvent.getFactId(), event);
                    break;
                }
                case 4: {
                    Event objEvent;
                    Long fhId;
                    ActivationLogEvent activationEvent = (ActivationLogEvent)logEvent;
                    event.setString("Activation created: Rule " + activationEvent.getRule() + " " + activationEvent.getDeclarations());
                    Event mostRecentObjEvent = null;
                    Long[] longArray = this.getEventFactHandleIds(activationEvent);
                    int n = longArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        fhId = longArray[n2];
                        objEvent = (Event)objectMap.get(fhId);
                        if (objEvent != null && (mostRecentObjEvent == null || mostRecentObjEvent.recency < objEvent.recency)) {
                            mostRecentObjEvent = objEvent;
                        }
                        ++n2;
                    }
                    if (mostRecentObjEvent != null) {
                        mostRecentObjEvent.addSubEvent(event);
                    }
                    activationMap.put(activationEvent.getActivationId(), event);
                    break;
                }
                case 5: {
                    Event objEvent;
                    Long fhId;
                    ActivationLogEvent activationEvent = (ActivationLogEvent)logEvent;
                    event.setString("Activation cancelled: Rule " + activationEvent.getRule() + " " + activationEvent.getDeclarations());
                    Event mostRecentObjEvent = null;
                    Long[] longArray = this.getEventFactHandleIds(activationEvent);
                    int n = longArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        fhId = longArray[n3];
                        objEvent = (Event)objectMap.get(fhId);
                        if (objEvent != null && (mostRecentObjEvent == null || mostRecentObjEvent.recency < objEvent.recency)) {
                            mostRecentObjEvent = objEvent;
                        }
                        ++n3;
                    }
                    if (mostRecentObjEvent != null) {
                        mostRecentObjEvent.addSubEvent(event);
                    }
                    event.setCauseEvent((Event)activationMap.get(activationEvent.getActivationId()));
                    break;
                }
                case 6: {
                    ActivationLogEvent activationEvent = (ActivationLogEvent)logEvent;
                    event.setString("Activation executed: Rule " + activationEvent.getRule() + " " + activationEvent.getDeclarations());
                    events.add(event);
                    beforeEvents.push(event);
                    event.setCauseEvent((Event)activationMap.get(activationEvent.getActivationId()));
                    break;
                }
                case 7: {
                    beforeEvents.pop();
                    break;
                }
                case 8: {
                    RuleFlowLogEvent ruleFlowEvent = (RuleFlowLogEvent)logEvent;
                    event.setString("Process started: " + ruleFlowEvent.getProcessName() + "[" + ruleFlowEvent.getProcessId() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 9: {
                    beforeEvents.pop();
                    break;
                }
                case 10: {
                    RuleFlowLogEvent ruleFlowEvent = (RuleFlowLogEvent)logEvent;
                    event.setString("Process completed: " + ruleFlowEvent.getProcessName() + "[" + ruleFlowEvent.getProcessId() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 11: {
                    beforeEvents.pop();
                    break;
                }
                case 24: {
                    RuleFlowNodeLogEvent ruleFlowNodeEvent = (RuleFlowNodeLogEvent)logEvent;
                    event.setString("Process node triggered: " + ruleFlowNodeEvent.getNodeName() + " in process " + ruleFlowNodeEvent.getProcessName() + "[" + ruleFlowNodeEvent.getProcessId() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 25: {
                    beforeEvents.pop();
                    break;
                }
                case 12: {
                    RuleFlowGroupLogEvent ruleFlowGroupEvent = (RuleFlowGroupLogEvent)logEvent;
                    event.setString("RuleFlow Group activated: " + ruleFlowGroupEvent.getGroupName() + "[size=" + ruleFlowGroupEvent.getSize() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 13: {
                    beforeEvents.pop();
                    break;
                }
                case 14: {
                    RuleFlowGroupLogEvent ruleFlowGroupEvent = (RuleFlowGroupLogEvent)logEvent;
                    event.setString("RuleFlow Group deactivated: " + ruleFlowGroupEvent.getGroupName() + "[size=" + ruleFlowGroupEvent.getSize() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 15: {
                    beforeEvents.pop();
                    break;
                }
                case 16: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)logEvent;
                    event.setString("Package added: " + ruleBaseEvent.getPackageName());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 17: {
                    beforeEvents.pop();
                    break;
                }
                case 18: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)logEvent;
                    event.setString("Package removed: " + ruleBaseEvent.getPackageName());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 19: {
                    beforeEvents.pop();
                    break;
                }
                case 20: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)logEvent;
                    event.setString("Rule added: " + ruleBaseEvent.getRuleName());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 21: {
                    beforeEvents.pop();
                    break;
                }
                case 22: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)logEvent;
                    event.setString("Rule removed: " + ruleBaseEvent.getRuleName());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 23: {
                    beforeEvents.pop();
                    break;
                }
            }
        }
        return events;
    }

    private Long[] getEventFactHandleIds(ActivationLogEvent event) {
        String[] ids = event.getFactHandleIds().split(",");
        Long[] longIds = new Long[ids.length];
        int i = 0;
        while (i < ids.length) {
            longIds[i] = Long.parseLong(ids[i]);
            ++i;
        }
        return longIds;
    }

    protected List<Event> createEventList(List<LogEvent> logEvents) {
        Iterator<LogEvent> iterator = logEvents.iterator();
        ArrayList<Event> events = new ArrayList<Event>();
        Stack<Event> beforeEvents = new Stack<Event>();
        ArrayList<Event> newActivations = new ArrayList<Event>();
        HashMap<String, Event> activationMap = new HashMap<String, Event>();
        HashMap<Long, Event> objectMap = new HashMap<Long, Event>();
        while (iterator.hasNext()) {
            LogEvent inEvent = iterator.next();
            Event event = new Event(inEvent.getType());
            switch (inEvent.getType()) {
                case 1: {
                    ObjectLogEvent inObjectEvent = (ObjectLogEvent)inEvent;
                    event.setString("Object inserted (" + inObjectEvent.getFactId() + "): " + inObjectEvent.getObjectToString());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    event.addSubEvents(newActivations);
                    newActivations.clear();
                    objectMap.put(new Long(((ObjectLogEvent)inEvent).getFactId()), event);
                    break;
                }
                case 2: {
                    ObjectLogEvent inObjectEvent = (ObjectLogEvent)inEvent;
                    event.setString("Object updated (" + inObjectEvent.getFactId() + "): " + inObjectEvent.getObjectToString());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    event.addSubEvents(newActivations);
                    newActivations.clear();
                    Event assertEvent = (Event)objectMap.get(new Long(((ObjectLogEvent)inEvent).getFactId()));
                    if (assertEvent == null) break;
                    event.setCauseEvent(assertEvent);
                    break;
                }
                case 3: {
                    ObjectLogEvent inObjectEvent = (ObjectLogEvent)inEvent;
                    event.setString("Object removed (" + inObjectEvent.getFactId() + "): " + inObjectEvent.getObjectToString());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    event.addSubEvents(newActivations);
                    newActivations.clear();
                    Event assertEvent = (Event)objectMap.get(new Long(((ObjectLogEvent)inEvent).getFactId()));
                    if (assertEvent == null) break;
                    event.setCauseEvent(assertEvent);
                    break;
                }
                case 4: {
                    ActivationLogEvent inActivationEvent = (ActivationLogEvent)inEvent;
                    event.setString("Activation created: Rule " + inActivationEvent.getRule() + " " + inActivationEvent.getDeclarations());
                    newActivations.add(event);
                    activationMap.put(((ActivationLogEvent)inEvent).getActivationId(), event);
                    break;
                }
                case 5: {
                    ActivationLogEvent inActivationEvent = (ActivationLogEvent)inEvent;
                    event.setString("Activation cancelled: Rule " + inActivationEvent.getRule() + " " + inActivationEvent.getDeclarations());
                    newActivations.add(event);
                    event.setCauseEvent((Event)activationMap.get(((ActivationLogEvent)inEvent).getActivationId()));
                    break;
                }
                case 6: {
                    ActivationLogEvent inActivationEvent = (ActivationLogEvent)inEvent;
                    event.setString("Activation executed: Rule " + inActivationEvent.getRule() + " " + inActivationEvent.getDeclarations());
                    events.add(event);
                    beforeEvents.push(event);
                    event.setCauseEvent((Event)activationMap.get(((ActivationLogEvent)inEvent).getActivationId()));
                    break;
                }
                case 7: {
                    beforeEvents.pop();
                    break;
                }
                case 8: {
                    RuleFlowLogEvent inRuleFlowEvent = (RuleFlowLogEvent)inEvent;
                    event.setString("Process started: " + inRuleFlowEvent.getProcessName() + "[" + inRuleFlowEvent.getProcessId() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 9: {
                    beforeEvents.pop();
                    break;
                }
                case 10: {
                    RuleFlowLogEvent inRuleFlowEvent = (RuleFlowLogEvent)inEvent;
                    event.setString("Process completed: " + inRuleFlowEvent.getProcessName() + "[" + inRuleFlowEvent.getProcessId() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 11: {
                    beforeEvents.pop();
                    break;
                }
                case 24: {
                    RuleFlowNodeLogEvent inRuleFlowNodeEvent = (RuleFlowNodeLogEvent)inEvent;
                    event.setString("Process node triggered: " + inRuleFlowNodeEvent.getNodeName() + " in process " + inRuleFlowNodeEvent.getProcessName() + "[" + inRuleFlowNodeEvent.getProcessId() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 25: {
                    beforeEvents.pop();
                    break;
                }
                case 12: {
                    RuleFlowGroupLogEvent inRuleFlowGroupEvent = (RuleFlowGroupLogEvent)inEvent;
                    event.setString("RuleFlow Group activated: " + inRuleFlowGroupEvent.getGroupName() + "[size=" + inRuleFlowGroupEvent.getSize() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 13: {
                    beforeEvents.pop();
                    break;
                }
                case 14: {
                    RuleFlowGroupLogEvent inRuleFlowGroupEvent = (RuleFlowGroupLogEvent)inEvent;
                    event.setString("RuleFlow Group deactivated: " + inRuleFlowGroupEvent.getGroupName() + "[size=" + inRuleFlowGroupEvent.getSize() + "]");
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 15: {
                    beforeEvents.pop();
                    break;
                }
                case 16: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)inEvent;
                    event.setString("Package added: " + ruleBaseEvent.getPackageName());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 17: {
                    beforeEvents.pop();
                    break;
                }
                case 18: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)inEvent;
                    event.setString("Package removed: " + ruleBaseEvent.getPackageName());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 19: {
                    beforeEvents.pop();
                    break;
                }
                case 20: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)inEvent;
                    event.setString("Rule added: " + ruleBaseEvent.getRuleName());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 21: {
                    if (beforeEvents.isEmpty()) break;
                    Event beforeEvent = (Event)beforeEvents.pop();
                    beforeEvent.addSubEvents(newActivations);
                    newActivations.clear();
                    break;
                }
                case 22: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)inEvent;
                    event.setString("Rule removed: " + ruleBaseEvent.getRuleName());
                    if (!beforeEvents.isEmpty()) {
                        ((Event)beforeEvents.peek()).addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    beforeEvents.push(event);
                    break;
                }
                case 23: {
                    if (beforeEvents.isEmpty()) break;
                    Event beforeEvent = (Event)beforeEvents.pop();
                    beforeEvent.addSubEvents(newActivations);
                    newActivations.clear();
                    break;
                }
            }
        }
        return events;
    }

    protected List<Event> createDrools4EventList(List<LogEvent> logEvents) {
        Iterator<LogEvent> iterator = logEvents.iterator();
        ArrayList<Event> events = new ArrayList<Event>();
        Event currentBeforeActivationEvent = null;
        Event currentBeforePackageEvent = null;
        ArrayList<Event> newActivations = new ArrayList<Event>();
        HashMap<String, Event> activationMap = new HashMap<String, Event>();
        HashMap<Long, Event> objectMap = new HashMap<Long, Event>();
        while (iterator.hasNext()) {
            LogEvent inEvent = iterator.next();
            Event event = new Event(inEvent.getType());
            switch (inEvent.getType()) {
                case 1: {
                    ObjectLogEvent inObjectEvent = (ObjectLogEvent)inEvent;
                    event.setString("Object inserted (" + inObjectEvent.getFactId() + "): " + inObjectEvent.getObjectToString());
                    if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    event.addSubEvents(newActivations);
                    newActivations.clear();
                    objectMap.put(new Long(((ObjectLogEvent)inEvent).getFactId()), event);
                    break;
                }
                case 2: {
                    ObjectLogEvent inObjectEvent = (ObjectLogEvent)inEvent;
                    event.setString("Object updated (" + inObjectEvent.getFactId() + "): " + inObjectEvent.getObjectToString());
                    if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    event.addSubEvents(newActivations);
                    newActivations.clear();
                    Event assertEvent = (Event)objectMap.get(new Long(((ObjectLogEvent)inEvent).getFactId()));
                    if (assertEvent == null) break;
                    event.setCauseEvent(assertEvent);
                    break;
                }
                case 3: {
                    ObjectLogEvent inObjectEvent = (ObjectLogEvent)inEvent;
                    event.setString("Object removed (" + inObjectEvent.getFactId() + "): " + inObjectEvent.getObjectToString());
                    if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    event.addSubEvents(newActivations);
                    newActivations.clear();
                    Event assertEvent = (Event)objectMap.get(new Long(((ObjectLogEvent)inEvent).getFactId()));
                    if (assertEvent == null) break;
                    event.setCauseEvent(assertEvent);
                    break;
                }
                case 4: {
                    ActivationLogEvent inActivationEvent = (ActivationLogEvent)inEvent;
                    event.setString("Activation created: Rule " + inActivationEvent.getRule() + " " + inActivationEvent.getDeclarations());
                    newActivations.add(event);
                    activationMap.put(((ActivationLogEvent)inEvent).getActivationId(), event);
                    break;
                }
                case 5: {
                    ActivationLogEvent inActivationEvent = (ActivationLogEvent)inEvent;
                    event.setString("Activation cancelled: Rule " + inActivationEvent.getRule() + " " + inActivationEvent.getDeclarations());
                    newActivations.add(event);
                    event.setCauseEvent((Event)activationMap.get(((ActivationLogEvent)inEvent).getActivationId()));
                    break;
                }
                case 6: {
                    ActivationLogEvent inActivationEvent = (ActivationLogEvent)inEvent;
                    event.setString("Activation executed: Rule " + inActivationEvent.getRule() + " " + inActivationEvent.getDeclarations());
                    events.add(event);
                    currentBeforeActivationEvent = event;
                    event.setCauseEvent((Event)activationMap.get(((ActivationLogEvent)inEvent).getActivationId()));
                    break;
                }
                case 7: {
                    currentBeforeActivationEvent = null;
                    break;
                }
                case 8: {
                    RuleFlowLogEvent inRuleFlowEvent = (RuleFlowLogEvent)inEvent;
                    event.setString("RuleFlow started: " + inRuleFlowEvent.getProcessName() + "[" + inRuleFlowEvent.getProcessId() + "]");
                    if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                        break;
                    }
                    events.add(event);
                    break;
                }
                case 9: {
                    RuleFlowLogEvent inRuleFlowEvent = (RuleFlowLogEvent)inEvent;
                    event.setString("RuleFlow completed: " + inRuleFlowEvent.getProcessName() + "[" + inRuleFlowEvent.getProcessId() + "]");
                    if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                        break;
                    }
                    events.add(event);
                    break;
                }
                case 10: {
                    RuleFlowGroupLogEvent inRuleFlowGroupEvent = (RuleFlowGroupLogEvent)inEvent;
                    event.setString("RuleFlowGroup activated: " + inRuleFlowGroupEvent.getGroupName() + "[size=" + inRuleFlowGroupEvent.getSize() + "]");
                    if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                        break;
                    }
                    events.add(event);
                    break;
                }
                case 11: {
                    RuleFlowGroupLogEvent inRuleFlowGroupEvent = (RuleFlowGroupLogEvent)inEvent;
                    event.setString("RuleFlowGroup deactivated: " + inRuleFlowGroupEvent.getGroupName() + "[size=" + inRuleFlowGroupEvent.getSize() + "]");
                    if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                        break;
                    }
                    events.add(event);
                    break;
                }
                case 12: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)inEvent;
                    event.setString("Package added: " + ruleBaseEvent.getPackageName());
                    if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    currentBeforePackageEvent = event;
                    break;
                }
                case 13: {
                    currentBeforePackageEvent = null;
                    break;
                }
                case 14: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)inEvent;
                    event.setString("Package removed: " + ruleBaseEvent.getPackageName());
                    if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    currentBeforePackageEvent = event;
                    break;
                }
                case 15: {
                    currentBeforePackageEvent = null;
                    break;
                }
                case 17: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)inEvent;
                    event.setString("Rule added: " + ruleBaseEvent.getRuleName());
                    if (currentBeforePackageEvent != null) {
                        currentBeforePackageEvent.addSubEvent(event);
                    } else if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    event.addSubEvents(newActivations);
                    newActivations.clear();
                    break;
                }
                case 19: {
                    RuleBaseLogEvent ruleBaseEvent = (RuleBaseLogEvent)inEvent;
                    event.setString("Rule removed: " + ruleBaseEvent.getRuleName());
                    if (currentBeforePackageEvent != null) {
                        currentBeforePackageEvent.addSubEvent(event);
                    } else if (currentBeforeActivationEvent != null) {
                        currentBeforeActivationEvent.addSubEvent(event);
                    } else {
                        events.add(event);
                    }
                    event.addSubEvents(newActivations);
                    newActivations.clear();
                }
            }
        }
        return events;
    }

    public void deleteLog() {
        if (this.logFileName != null) {
            File file = new File(this.logFileName);
            try {
                file.delete();
                this.setLogFile(null);
                this.refresh();
            }
            catch (Throwable t) {
                t.printStackTrace();
                DroolsEclipsePlugin.log(t);
            }
        }
    }

    protected void becomesVisible() {
        this.refresh();
    }

    protected String getHelpContextId() {
        return null;
    }

    public Event getSelectedEvent() {
        Object selected;
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof Event) {
            return (Event)selected;
        }
        return null;
    }

    public void showEvent(Event event) {
        ((TreeViewer)this.getViewer()).reveal((Object)event);
    }

    protected void fillContextMenu(IMenuManager menu) {
        Event causeEvent;
        Event selected = this.getSelectedEvent();
        if (selected != null && (causeEvent = selected.getCauseEvent()) != null) {
            menu.add(this.getAction("ShowEventCause"));
        }
        menu.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void createActions() {
        this.deleteAction = new DeleteLogAction(this);
        this.setAction("ClearLog", this.deleteAction);
        this.deleteAction.setEnabled(this.logFileName != null);
        this.refreshAction = new RefreshLogAction(this);
        this.setAction("RefreshLog", this.refreshAction);
        this.refreshAction.setEnabled(this.logFileName != null);
        Action action = new OpenLogAction(this);
        this.setAction("OpenLog", (IAction)action);
        action = new ShowEventCauseAction(this);
        this.setAction("ShowEventCause", (IAction)action);
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add(this.getAction("OpenLog"));
        tbm.add(this.getAction("RefreshLog"));
        tbm.add(this.getAction("ClearLog"));
    }

    public void saveState(IMemento memento) {
        memento.putString(LOG_FILE_NAME, this.logFileName);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.logFileName = memento.getString(LOG_FILE_NAME);
        }
    }

    public class AuditLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            Event selected = AuditView.this.getSelectedEvent();
            if (selected != null && element.equals(selected.getCauseEvent())) {
                Color color = DroolsEclipsePlugin.getDefault().getColor(AuditView.CAUSE_EVENT_COLOR);
                if (color == null) {
                    color = new Color((Device)AuditView.this.getControl().getDisplay(), 0, 255, 0);
                    DroolsEclipsePlugin.getDefault().setColor(AuditView.CAUSE_EVENT_COLOR, color);
                }
                return color;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof Event) {
                int type = ((Event)element).getType();
                if (AuditView.this.drools4) {
                    switch (type) {
                        case 1: {
                            return DroolsPluginImages.getImage("Insert");
                        }
                        case 2: {
                            return DroolsPluginImages.getImage("Update");
                        }
                        case 3: {
                            return DroolsPluginImages.getImage("RetractO");
                        }
                        case 4: {
                            return DroolsPluginImages.getImage("CreateActivation");
                        }
                        case 5: {
                            return DroolsPluginImages.getImage("CancelActivation");
                        }
                        case 6: {
                            return DroolsPluginImages.getImage("ExecuteActivation");
                        }
                        case 8: {
                            return DroolsPluginImages.getImage("RuleFlow");
                        }
                        case 9: {
                            return DroolsPluginImages.getImage("RuleFlow");
                        }
                        case 24: {
                            return DroolsPluginImages.getImage("RuleFlowNodeTriggered");
                        }
                        case 10: {
                            return DroolsPluginImages.getImage("RuleFlowGroup");
                        }
                        case 11: {
                            return DroolsPluginImages.getImage("RuleFlowGroup");
                        }
                        case 12: {
                            return DroolsPluginImages.getImage("Drools");
                        }
                        case 14: {
                            return DroolsPluginImages.getImage("Drools");
                        }
                        case 17: {
                            return DroolsPluginImages.getImage("Drools");
                        }
                        case 19: {
                            return DroolsPluginImages.getImage("Drools");
                        }
                    }
                }
                switch (type) {
                    case 1: {
                        return DroolsPluginImages.getImage("Insert");
                    }
                    case 2: {
                        return DroolsPluginImages.getImage("Update");
                    }
                    case 3: {
                        return DroolsPluginImages.getImage("RetractO");
                    }
                    case 4: {
                        return DroolsPluginImages.getImage("CreateActivation");
                    }
                    case 5: {
                        return DroolsPluginImages.getImage("CancelActivation");
                    }
                    case 6: {
                        return DroolsPluginImages.getImage("ExecuteActivation");
                    }
                    case 8: {
                        return DroolsPluginImages.getImage("RuleFlow");
                    }
                    case 10: {
                        return DroolsPluginImages.getImage("RuleFlow");
                    }
                    case 24: {
                        return DroolsPluginImages.getImage("RuleFlowNodeTriggered");
                    }
                    case 12: {
                        return DroolsPluginImages.getImage("RuleFlowGroup");
                    }
                    case 14: {
                        return DroolsPluginImages.getImage("RuleFlowGroup");
                    }
                    case 16: {
                        return DroolsPluginImages.getImage("Drools");
                    }
                    case 18: {
                        return DroolsPluginImages.getImage("Drools");
                    }
                    case 20: {
                        return DroolsPluginImages.getImage("Drools");
                    }
                    case 22: {
                        return DroolsPluginImages.getImage("Drools");
                    }
                }
                return null;
            }
            return null;
        }
    }

    public static class Event {
        private static long counter = 0L;
        private final long recency = counter++;
        private String toString;
        private int type;
        private List<Event> subEvents = new ArrayList<Event>();
        private Event causeEvent;

        public Event(int type) {
            this.type = type;
        }

        public void setString(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }

        public int getType() {
            return this.type;
        }

        public void addSubEvent(Event subEvent) {
            this.subEvents.add(subEvent);
        }

        public void addSubEvents(Collection<Event> subEvents) {
            this.subEvents.addAll(subEvents);
        }

        public Object[] getSubEvents() {
            return this.subEvents.toArray();
        }

        public boolean hasSubEvents() {
            return !this.subEvents.isEmpty();
        }

        public void setCauseEvent(Event causeEvent) {
            this.causeEvent = causeEvent;
        }

        public Event getCauseEvent() {
            return this.causeEvent;
        }
    }
}

