/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.util.Hashtable;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.internal.authentication.Parser;
import org.eclipse.webdav.internal.authentication.ParserException;

public class AuthenticationInfo {
    private String authInfo;
    private Parser parser;
    private Hashtable info;

    public AuthenticationInfo(String authInfo) throws ParserException {
        this.authInfo = authInfo;
        this.parser = new Parser(authInfo);
        this.parse();
    }

    public String getCNonce() {
        return (String)this.info.get("cnonce");
    }

    public String getMessageQop() {
        return (String)this.info.get("qop");
    }

    public String getNextNonce() {
        return (String)this.info.get("nextnonce");
    }

    public String getNonceCount() {
        return (String)this.info.get("nc");
    }

    public String getResponseAuth() {
        return (String)this.info.get("rspauth");
    }

    private void parse() throws ParserException {
        this.info = new Hashtable(5);
        boolean done = false;
        while (!done) {
            String param = this.parser.nextToken();
            this.parser.match('=');
            String value = null;
            this.parser.checkPosition();
            value = this.authInfo.charAt(this.parser.pos) == '\"' ? this.parser.nextQuotedString() : this.parser.nextToken();
            this.info.put(param, value);
            this.parser.skipWhiteSpace();
            boolean bl = done = this.parser.pos == this.authInfo.length();
            if (done) continue;
            this.parser.match(',');
            this.parser.skipWhiteSpace();
        }
        if (this.getNextNonce() == null) {
            throw new ParserException(Policy.bind("exception.missingNextnonce"));
        }
    }
}

