/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.space;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.server.IKieSpaceHandler;

public class DeleteSpaceAction
extends KieNavigatorAction {
    public DeleteSpaceAction(ISelectionProvider provider) {
        super(provider, "Delete Space...");
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        boolean deleteConfirmed = MessageDialog.openConfirm((Shell)DeleteSpaceAction.getShell(), (String)"Delete Space", (String)("Are you sure you want to delete the Space '" + container.getName() + "'?"));
        if (deleteConfirmed) {
            try {
                this.getDelegate().deleteSpace((IKieSpaceHandler)container.getHandler());
                DeleteSpaceAction.refreshViewer(container.getParent());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

