/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.ColorManager;
import org.drools.eclipse.editors.DRLHyperlinkDetector;
import org.drools.eclipse.editors.DRLReconcilingStrategy;
import org.drools.eclipse.editors.completion.DefaultCompletionProcessor;
import org.drools.eclipse.editors.completion.RuleCompletionProcessor;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.editors.scanners.DRLScanner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class DRLSourceViewerConfig
extends SourceViewerConfiguration {
    private DRLScanner scanner;
    private AbstractRuleEditor editor;

    public DRLSourceViewerConfig(AbstractRuleEditor editor) {
        this.editor = editor;
    }

    protected AbstractRuleEditor getEditor() {
        return this.editor;
    }

    protected DRLScanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new DRLScanner();
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__partition_rule_content");
        reconciler.setRepairer((IPresentationRepairer)dr, "__partition_rule_content");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(ColorManager.getInstance().getColor(ColorManager.SINGLE_LINE_COMMENT))));
        reconciler.setDamager((IPresentationDamager)dr, "__partition_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__partition_multiline_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new DefaultCompletionProcessor(this.editor), "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new RuleCompletionProcessor(this.editor), "__partition_rule_content");
        assistant.setProposalPopupOrientation(10);
        return assistant;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return DRLPartionScanner.LEGAL_CONTENT_TYPES;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        MonoReconciler reconciler = null;
        if (sourceViewer != null) {
            reconciler = new MonoReconciler((IReconcilingStrategy)new DRLReconcilingStrategy(sourceViewer, this.editor), false);
            reconciler.setDelay(500);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        }
        return reconciler;
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] detectors = super.getHyperlinkDetectors(sourceViewer);
        if (detectors == null) {
            detectors = new IHyperlinkDetector[]{};
        }
        IHyperlinkDetector[] drlDetectors = new IHyperlinkDetector[detectors.length + 1];
        DRLHyperlinkDetector detector = new DRLHyperlinkDetector(this.editor);
        drlDetectors[0] = detector;
        System.arraycopy(detectors, 0, drlDetectors, 1, detectors.length);
        return drlDetectors;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return new MultipleHyperlinkPresenter(new RGB(0, 0, 255));
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

