/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Prop;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyUpdate
extends ElementEditor {
    public PropertyUpdate(Element root) throws MalformedElementException {
        super(root, "propertyupdate");
    }

    public Prop addRemove() {
        Element remove = PropertyUpdate.appendChild(this.root, "remove");
        Element prop = PropertyUpdate.appendChild(remove, "prop");
        Prop result = null;
        try {
            result = new Prop(prop);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public Prop addSet() {
        Element set = PropertyUpdate.appendChild(this.root, "set");
        Element prop = PropertyUpdate.appendChild(set, "prop");
        try {
            return new Prop(prop);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public static PropertyUpdate create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Element element = PropertyUpdate.create(document, "propertyupdate");
        PropertyUpdate result = null;
        try {
            result = new PropertyUpdate(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public Enumeration getSetsAndRemoves() throws MalformedElementException {
        Element setOrRemove = PropertyUpdate.getFirstChild(this.root, new String[]{"remove", "set"});
        PropertyUpdate.ensureNotNull(Policy.bind("ensure.missingRemoveOrSetElmt"), setOrRemove);
        Element property = null;
        while (setOrRemove != null && property == null) {
            Element prop = PropertyUpdate.getFirstChild(setOrRemove, "prop");
            PropertyUpdate.ensureNotNull(Policy.bind("ensure.missingPropElmt"), prop);
            property = PropertyUpdate.getChildElement(prop, true);
            if (property != null) continue;
            setOrRemove = PropertyUpdate.getNextSibling(setOrRemove, new String[]{"remove", "set"});
        }
        Element a = setOrRemove;
        Element c = property;
        Enumeration e = new Enumeration(a, c){
            Node currentSetOrRemove;
            Node currentProperty;
            {
                this.currentSetOrRemove = node;
                this.currentProperty = node2;
            }

            @Override
            public boolean hasMoreElements() {
                return this.currentProperty != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                Directive result = null;
                try {
                    result = new Directive((Element)this.currentProperty);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                this.currentProperty = PropertyUpdate.getNextSibling((Element)this.currentProperty);
                while (this.currentSetOrRemove != null && this.currentProperty == null) {
                    Element prop;
                    this.currentSetOrRemove = PropertyUpdate.getNextSibling((Element)this.currentSetOrRemove, new String[]{"remove", "set"});
                    if (this.currentSetOrRemove == null || (prop = PropertyUpdate.getFirstChild((Element)this.currentSetOrRemove, "prop")) == null) continue;
                    this.currentProperty = PropertyUpdate.getChildElement(prop, true);
                }
                return result;
            }
        };
        return e;
    }

    public class Directive
    extends ElementEditor {
        public Directive(Element element) throws MalformedElementException {
            super(element);
            Node parent = element.getParentNode();
            Directive.ensureDAVElement(parent, "prop", Policy.bind("ensure.expectingPropElmt"));
            Node grandparent = parent.getParentNode();
            Directive.ensure(Directive.isDAVElement(grandparent, "remove") || Directive.isDAVElement(grandparent, "set"), Policy.bind("ensure.expectingRemoveOrSetElmt"));
        }

        public Element getProperty() throws MalformedElementException {
            return this.root;
        }

        public boolean isRemove() throws MalformedElementException {
            Node parent = this.root.getParentNode();
            Directive.ensureDAVElement(parent, "prop", Policy.bind("ensure.expectingPropElmt"));
            Node grandparent = parent.getParentNode();
            return Directive.isDAVElement(grandparent, "remove");
        }

        public boolean isSet() throws MalformedElementException {
            Node parent = this.root.getParentNode();
            Directive.ensureDAVElement(parent, "prop", Policy.bind("ensure.expectingPropElmt"));
            Node grandparent = parent.getParentNode();
            return Directive.isDAVElement(grandparent, "set");
        }
    }
}

