/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.kie.eclipse.IKieConstants;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.IKieSpaceHandler;
import org.kie.eclipse.server.KieResourceHandler;
import org.kie.eclipse.utils.GitUtils;
import org.kie.eclipse.utils.PreferencesUtils;

public class KieRepositoryHandler
extends KieResourceHandler
implements IKieRepositoryHandler,
IKieConstants {
    Repository repository;

    public KieRepositoryHandler(IKieSpaceHandler space, String name) {
        super(space, name);
    }

    @Override
    public Object getResource() {
        return this.repository;
    }

    @Override
    public List<? extends IKieResourceHandler> getChildren() throws Exception {
        if (this.children == null || this.children.isEmpty()) {
            this.children = this.getDelegate().getProjects(this);
        }
        return this.children;
    }

    @Override
    public List<IKieProjectHandler> getProjects() throws Exception {
        return this.getChildren();
    }

    @Override
    public Object load() {
        if (this.repository == null) {
            try {
                File repoRoot = new File(PreferencesUtils.getRepoRoot(this));
                HashSet<File> gitDirs = new HashSet<File>();
                GitUtils.findGitDirsRecursive(repoRoot, gitDirs, false);
                block7: for (File dir : gitDirs) {
                    if (!this.getName().equals(dir.getParentFile().getName())) continue;
                    Git git = Git.open((File)dir);
                    Repository repository = git.getRepository();
                    StoredConfig storedConfig = repository.getConfig();
                    Set remotes = storedConfig.getSubsections("remote");
                    for (String remoteName : remotes) {
                        try {
                            String url = storedConfig.getString("remote", remoteName, "url");
                            URI uri = new URI(url);
                            int port = uri.getPort();
                            String host = uri.getHost();
                            String scheme = uri.getScheme();
                            String[] path = uri.getPath().split("/");
                            String repoName = path[path.length - 1];
                            if (!this.name.equals(repoName) || !host.equals(this.getServer().getHost()) || port != this.getDelegate().getGitPort() || !"ssh".equals(scheme)) continue;
                            this.repository = repository;
                            continue block7;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (git != null) {
                                git.close();
                                git = null;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.repository;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.repository != null) {
            this.repository.close();
            this.repository = null;
        }
    }

    @Override
    public boolean isLoaded() {
        return this.repository != null;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }
}

