/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.StateBasedNodeWrapper;
import org.drools.eclipse.flow.ruleflow.view.property.subprocess.SubProcessParameterInMappingPropertyDescriptor;
import org.drools.eclipse.flow.ruleflow.view.property.subprocess.SubProcessParameterOutMappingPropertyDescriptor;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.SubProcessNode;

public class SubProcessWrapper
extends StateBasedNodeWrapper {
    private static final long serialVersionUID = 510L;
    public static final String PROCESS_ID = "ProcessId";
    public static final String WAIT_FOR_COMPLETION = "WaitForCompletion";
    public static final String INDEPENDENT = "Independent";
    public static final String PARAMETER_IN_MAPPING = "ParameterInMapping";
    public static final String PARAMETER_OUT_MAPPING = "ParameterOutMapping";

    public SubProcessWrapper() {
        this.setNode((Node)new SubProcessNode());
        this.getSubProcessNode().setName("SubProcess");
    }

    @Override
    protected void initDescriptors() {
        super.initDescriptors();
        IPropertyDescriptor[] oldDescriptors = this.descriptors;
        boolean fullProps = this.isFullProperties();
        this.descriptors = new IPropertyDescriptor[oldDescriptors.length + (fullProps ? 7 : 6)];
        System.arraycopy(oldDescriptors, 0, this.descriptors, 0, oldDescriptors.length);
        if (fullProps) {
            this.descriptors[this.descriptors.length - 7] = new ComboBoxPropertyDescriptor((Object)WAIT_FOR_COMPLETION, "Wait for completion", new String[]{"true", "false"});
        }
        this.descriptors[this.descriptors.length - 6] = this.getOnEntryPropertyDescriptor();
        this.descriptors[this.descriptors.length - 5] = this.getOnExitPropertyDescriptor();
        this.descriptors[this.descriptors.length - 4] = new SubProcessParameterInMappingPropertyDescriptor(PARAMETER_IN_MAPPING, "Parameter In Mapping", this.getSubProcessNode());
        this.descriptors[this.descriptors.length - 3] = new SubProcessParameterOutMappingPropertyDescriptor(PARAMETER_OUT_MAPPING, "Parameter Out Mapping", this.getSubProcessNode());
        this.descriptors[this.descriptors.length - 2] = new ComboBoxPropertyDescriptor((Object)INDEPENDENT, INDEPENDENT, new String[]{"true", "false"});
        this.descriptors[this.descriptors.length - 1] = new TextPropertyDescriptor((Object)PROCESS_ID, PROCESS_ID);
    }

    public SubProcessNode getSubProcessNode() {
        return (SubProcessNode)this.getNode();
    }

    @Override
    public boolean acceptsIncomingConnection(ElementConnection connection, ElementWrapper source) {
        return super.acceptsIncomingConnection(connection, source) && this.getIncomingConnections().isEmpty();
    }

    @Override
    public boolean acceptsOutgoingConnection(ElementConnection connection, ElementWrapper target) {
        return super.acceptsOutgoingConnection(connection, target) && this.getOutgoingConnections().isEmpty();
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROCESS_ID.equals(id)) {
            String processId = this.getSubProcessNode().getProcessId();
            return processId == null ? "" : processId;
        }
        if (WAIT_FOR_COMPLETION.equals(id)) {
            return this.getSubProcessNode().isWaitForCompletion() ? new Integer(0) : new Integer(1);
        }
        if (INDEPENDENT.equals(id)) {
            return this.getSubProcessNode().isIndependent() ? new Integer(0) : new Integer(1);
        }
        if (PARAMETER_IN_MAPPING.equals(id)) {
            return this.getSubProcessNode().getInMappings();
        }
        if (PARAMETER_OUT_MAPPING.equals(id)) {
            return this.getSubProcessNode().getOutMappings();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void resetPropertyValue(Object id) {
        if (PROCESS_ID.equals(id)) {
            this.getSubProcessNode().setProcessId("");
        } else if (WAIT_FOR_COMPLETION.equals(id)) {
            this.getSubProcessNode().setWaitForCompletion(true);
        } else if (INDEPENDENT.equals(id)) {
            this.getSubProcessNode().setIndependent(true);
        } else if (PARAMETER_IN_MAPPING.equals(id)) {
            this.getSubProcessNode().setInMappings(new HashMap());
        } else if (PARAMETER_OUT_MAPPING.equals(id)) {
            this.getSubProcessNode().setOutMappings(new HashMap());
        } else {
            super.resetPropertyValue(id);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROCESS_ID.equals(id)) {
            this.getSubProcessNode().setProcessId((String)value);
        } else if (WAIT_FOR_COMPLETION.equals(id)) {
            this.getSubProcessNode().setWaitForCompletion((Integer)value == 0);
        } else if (INDEPENDENT.equals(id)) {
            this.getSubProcessNode().setIndependent((Integer)value == 0);
        } else if (PARAMETER_IN_MAPPING.equals(id)) {
            this.getSubProcessNode().setInMappings((Map)value);
        } else if (PARAMETER_OUT_MAPPING.equals(id)) {
            this.getSubProcessNode().setOutMappings((Map)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

