/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import org.eclipse.webdav.IContext;
import org.eclipse.webdav.IContextFactory;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.ILocatorFactory;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.dom.QualifiedNameImpl;
import org.eclipse.webdav.internal.kernel.ContextFactory;
import org.eclipse.webdav.internal.kernel.DocumentFactory;
import org.eclipse.webdav.internal.kernel.IDocumentFactory;
import org.eclipse.webdav.internal.kernel.LocatorFactory;
import org.w3c.dom.Document;

public class WebDAVFactory
implements ILocatorFactory,
IContextFactory,
IDocumentFactory {
    public static IContextFactory contextFactory = new ContextFactory();
    public static IDocumentFactory documentFactory = new DocumentFactory();
    public static ILocatorFactory locatorFactory = new LocatorFactory();

    @Override
    public IContext newContext() {
        return contextFactory.newContext();
    }

    @Override
    public IContext newContext(IContext baseContext) {
        return contextFactory.newContext(baseContext);
    }

    @Override
    public Document newDocument() {
        return documentFactory.newDocument();
    }

    @Override
    public ILocator newLocator(String resourceURL) {
        return locatorFactory.newLocator(resourceURL);
    }

    @Override
    public ILocator newLocator(String resourceURL, String label) {
        return locatorFactory.newLocator(resourceURL, label);
    }

    public QualifiedName newQualifiedName(String qualifier, String localName) {
        return new QualifiedNameImpl(qualifier, localName);
    }

    @Override
    public ILocator newStableLocator(String resourceURL) {
        return locatorFactory.newStableLocator(resourceURL);
    }
}

