/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.dialogs;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.Activator;
import org.kie.eclipse.navigator.view.actions.dialogs.AbstractKieRequestDialog;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestChangeListener;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestValidator;
import org.kie.eclipse.navigator.view.actions.dialogs.KieRequestDialogTextField;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieSpaceHandler;

public class CreateRepositoryRequestDialog
extends AbstractKieRequestDialog {
    IKieSpaceHandler space;
    KieRequestDialogTextField name;
    KieRequestDialogTextField description;
    KieRequestDialogTextField version;
    KieRequestDialogTextField groupId;

    public CreateRepositoryRequestDialog(Shell shell, final IKieSpaceHandler space) {
        super(shell, "Repository", new IKieRequestValidator(){

            @Override
            public String isValid(JsonObject object) {
                String name;
                JsonValue jv = object.get("name");
                String string = name = jv == null ? null : jv.asString().trim();
                if (name != null && !name.isEmpty()) {
                    try {
                        for (IKieRepositoryHandler rep : space.getRepositories()) {
                            if (!rep.getName().equals(name)) continue;
                            return "Repository '" + name + "' already exists in this Space";
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    return "Name is required";
                }
                return null;
            }
        });
        this.setTitleImage(Activator.getImage("icons/wizban/repository.png"));
        this.space = space;
    }

    @Override
    protected void createFields(Composite composite) {
        this.setMessage("Enter the Repository details");
        this.name = new KieRequestDialogTextField(composite, "Name:", "", this.properties, "name");
        this.name.setChangeListener(new IKieRequestChangeListener(){

            @Override
            public void objectChanged(JsonObject object) {
                CreateRepositoryRequestDialog.this.validate();
            }
        });
        this.description = new KieRequestDialogTextField(composite, "Description:", "", this.properties, "description");
        this.version = new KieRequestDialogTextField(composite, "Version:", "", this.properties, "version");
        this.version.setChangeListener(new IKieRequestChangeListener(){

            @Override
            public void objectChanged(JsonObject object) {
                CreateRepositoryRequestDialog.this.validate();
            }
        });
        this.groupId = new KieRequestDialogTextField(composite, "Group ID:", "", this.properties, "groupId");
        this.groupId.setChangeListener(new IKieRequestChangeListener(){

            @Override
            public void objectChanged(JsonObject object) {
                CreateRepositoryRequestDialog.this.validate();
            }
        });
    }
}

