/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.eclipse.WorkItemDefinitions;
import org.drools.eclipse.flow.common.editor.core.ElementContainer;
import org.drools.eclipse.flow.common.editor.core.ProcessWrapper;
import org.drools.eclipse.flow.common.editor.core.ProcessWrapperBuilder;
import org.drools.eclipse.flow.ruleflow.core.ActionWrapper;
import org.drools.eclipse.flow.ruleflow.core.CompositeContextNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.CompositeNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.ConnectionWrapper;
import org.drools.eclipse.flow.ruleflow.core.DynamicNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.EndNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.EventNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.FaultNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.ForEachNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.HumanTaskNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.JoinWrapper;
import org.drools.eclipse.flow.ruleflow.core.MilestoneWrapper;
import org.drools.eclipse.flow.ruleflow.core.NodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.RuleFlowProcessWrapper;
import org.drools.eclipse.flow.ruleflow.core.RuleSetNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.SplitWrapper;
import org.drools.eclipse.flow.ruleflow.core.StartNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.StateNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.SubProcessWrapper;
import org.drools.eclipse.flow.ruleflow.core.TimerWrapper;
import org.drools.eclipse.flow.ruleflow.core.WorkItemWrapper;
import org.eclipse.jdt.core.IJavaProject;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.WorkDefinition;
import org.jbpm.process.core.impl.WorkDefinitionImpl;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Connection;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;

public class RuleFlowWrapperBuilder
implements ProcessWrapperBuilder {
    @Override
    public ProcessWrapper getProcessWrapper(Process process, IJavaProject project) {
        if (process instanceof RuleFlowProcess) {
            RuleFlowProcess ruleFlowProcess = (RuleFlowProcess)process;
            RuleFlowProcessWrapper processWrapper = new RuleFlowProcessWrapper();
            processWrapper.localSetProcess(process);
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.addAll(Arrays.asList(ruleFlowProcess.getNodes()));
            HashSet<org.kie.api.definition.process.Connection> connections = new HashSet<org.kie.api.definition.process.Connection>();
            RuleFlowWrapperBuilder.processNodes(nodes, connections, processWrapper, project);
            return processWrapper;
        }
        return null;
    }

    public static void processNodes(Set<Node> nodes, Set<org.kie.api.definition.process.Connection> connections, ElementContainer container, IJavaProject project) {
        HashMap<Node, NodeWrapper> nodeWrappers = new HashMap<Node, NodeWrapper>();
        for (Node node : nodes) {
            NodeWrapper nodeWrapper = RuleFlowWrapperBuilder.getNodeWrapper(node, project);
            nodeWrapper.setNode((org.jbpm.workflow.core.Node)node);
            nodeWrapper.setParent(container);
            container.localAddElement(nodeWrapper);
            nodeWrappers.put(node, nodeWrapper);
            for (List inConnections : node.getIncomingConnections().values()) {
                for (org.kie.api.definition.process.Connection connection : inConnections) {
                    connections.add(connection);
                }
            }
            for (List outConnections : node.getOutgoingConnections().values()) {
                for (org.kie.api.definition.process.Connection connection : outConnections) {
                    connections.add(connection);
                }
            }
            if (!(node instanceof CompositeNode)) continue;
            HashSet<Node> subNodes = new HashSet<Node>();
            Node[] nodeArray = ((CompositeNode)node).getNodes();
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Node subNode = nodeArray[n2];
                subNodes.add(subNode);
                ++n2;
            }
            if (subNodes.size() <= 0) continue;
            RuleFlowWrapperBuilder.processNodes(subNodes, new HashSet<org.kie.api.definition.process.Connection>(), (CompositeNodeWrapper)nodeWrapper, project);
        }
        for (org.kie.api.definition.process.Connection connection : connections) {
            ConnectionWrapper connectionWrapper = new ConnectionWrapper();
            connectionWrapper.localSetConnection((Connection)connection);
            connectionWrapper.localSetBendpoints(null);
            NodeWrapper from = (NodeWrapper)nodeWrappers.get(connection.getFrom());
            NodeWrapper to = (NodeWrapper)nodeWrappers.get(connection.getTo());
            if (from == null || to == null) continue;
            connectionWrapper.localSetSource(from);
            from.localAddOutgoingConnection(connectionWrapper);
            connectionWrapper.localSetTarget(to);
            to.localAddIncomingConnection(connectionWrapper);
        }
    }

    private static NodeWrapper getNodeWrapper(Node node, IJavaProject project) {
        if (node instanceof StartNode) {
            return new StartNodeWrapper();
        }
        if (node instanceof EndNode) {
            return new EndNodeWrapper();
        }
        if (node instanceof ActionNode) {
            return new ActionWrapper();
        }
        if (node instanceof RuleSetNode) {
            return new RuleSetNodeWrapper();
        }
        if (node instanceof SubProcessNode) {
            return new SubProcessWrapper();
        }
        if (node instanceof ForEachNode) {
            return new ForEachNodeWrapper();
        }
        if (node instanceof DynamicNode) {
            return new DynamicNodeWrapper();
        }
        if (node instanceof StateNode) {
            return new StateNodeWrapper();
        }
        if (node instanceof CompositeContextNode) {
            return new CompositeContextNodeWrapper();
        }
        if (node instanceof Join) {
            return new JoinWrapper();
        }
        if (node instanceof Split) {
            return new SplitWrapper();
        }
        if (node instanceof MilestoneNode) {
            return new MilestoneWrapper();
        }
        if (node instanceof FaultNode) {
            return new FaultNodeWrapper();
        }
        if (node instanceof TimerNode) {
            return new TimerWrapper();
        }
        if (node instanceof HumanTaskNode) {
            return new HumanTaskNodeWrapper();
        }
        if (node instanceof WorkItemNode) {
            WorkItemWrapper workItemWrapper = new WorkItemWrapper();
            Work work = ((WorkItemNode)node).getWork();
            if (work != null && work.getName() != null) {
                try {
                    WorkDefinition workDefinition = WorkItemDefinitions.getWorkDefinitions(project).get(work.getName());
                    if (workDefinition == null) {
                        workDefinition = new WorkDefinitionImpl();
                        ((WorkDefinitionImpl)workDefinition).setName(work.getName());
                    }
                    workItemWrapper.setWorkDefinition(workDefinition);
                }
                catch (Throwable throwable) {}
            }
            return workItemWrapper;
        }
        if (node instanceof EventNode) {
            return new EventNodeWrapper();
        }
        throw new IllegalArgumentException("Could not find node wrapper for node " + node);
    }
}

