/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.dialogs;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.Activator;
import org.kie.eclipse.navigator.view.actions.dialogs.AbstractKieRequestDialog;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestChangeListener;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestValidator;
import org.kie.eclipse.navigator.view.actions.dialogs.KieRequestDialogTextField;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieSpaceHandler;

public class CreateSpaceRequestDialog
extends AbstractKieRequestDialog {
    IKieServerHandler server;
    KieRequestDialogTextField name;
    KieRequestDialogTextField description;
    KieRequestDialogTextField owner;
    KieRequestDialogTextField defaultGroupId;

    public CreateSpaceRequestDialog(Shell shell, final IKieServerHandler server) {
        super(shell, "Space", new IKieRequestValidator(){

            @Override
            public String isValid(JsonObject object) {
                String owner;
                JsonValue jv = object.get("name");
                String name = jv == null ? null : jv.asString().trim();
                jv = object.get("owner");
                String string = owner = jv == null ? null : jv.asString().trim();
                if (name != null && !name.isEmpty()) {
                    try {
                        for (IKieSpaceHandler space : server.getSpaces()) {
                            if (!space.getName().equals(name)) continue;
                            return "Space '" + name + "' already exists";
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    return "Name is required";
                }
                if (owner == null || owner.isEmpty()) {
                    return "Owner is required";
                }
                return null;
            }
        });
        this.setTitleImage(Activator.getImage("icons/wizban/space.png"));
        this.server = server;
    }

    @Override
    protected void createFields(Composite composite) {
        this.setMessage("Enter the Space details");
        this.name = new KieRequestDialogTextField(composite, "Name:", "", this.properties, "name");
        this.name.setChangeListener(new IKieRequestChangeListener(){

            @Override
            public void objectChanged(JsonObject object) {
                CreateSpaceRequestDialog.this.validate();
            }
        });
        this.description = new KieRequestDialogTextField(composite, "Description:", "", this.properties, "description");
        this.owner = new KieRequestDialogTextField(composite, "Owner:", "", this.properties, "owner");
        this.owner.setChangeListener(new IKieRequestChangeListener(){

            @Override
            public void objectChanged(JsonObject object) {
                CreateSpaceRequestDialog.this.validate();
            }
        });
        this.defaultGroupId = new KieRequestDialogTextField(composite, "Default Group ID:", "", this.properties, "defaultGroupId");
    }
}

