/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class LabelFieldEditor
extends FieldEditor {
    public static int UNLIMITED = -1;
    Label labelField;
    String labelText;
    private int widthInChars = UNLIMITED;

    public LabelFieldEditor() {
    }

    public LabelFieldEditor(String labelText, Composite parent) {
        super("NONE", "", parent);
        this.labelText = labelText;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.labelField.getLayoutData();
        gd.horizontalSpan = numColumns;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.labelField = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.labelField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.labelField.setLayoutData((Object)gd);
    }

    public Label getTextControl(Composite parent) {
        if (this.labelField == null) {
            this.labelField = new Label(parent, 0);
            this.labelField.setFont(parent.getFont());
        }
        if (this.labelText != null) {
            this.labelField.setText(this.labelText);
        }
        return this.labelField;
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 1;
    }
}

