/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.model.ResourceHistoryEntry;

public class GuvnorMetadataUtils {
    private static final QualifiedName CONTROLLED_PROJECT_PROPERTY = new QualifiedName("org.drools.guvnor", "guvnorControlled");

    public static IFile findGuvnorMetadata(IResource resource) {
        IFile res = null;
        IPath dir = resource.getFullPath().removeLastSegments(1);
        IPath mdpath = dir.append(".guvnorinfo").append("." + resource.getName());
        IResource mdResource = resource.getWorkspace().getRoot().findMember(mdpath);
        if (mdResource != null && mdResource.exists() && mdResource instanceof IFile) {
            res = (IFile)mdResource;
        }
        return res;
    }

    public static boolean addResourceToGuvnor(String repLoc, String targetLoc, IFile selectedFile) {
        boolean res = false;
        try {
            IWebDavClient client;
            String fullPath;
            block8: {
                fullPath = String.valueOf(targetLoc) + selectedFile.getName();
                client = WebDavServerCache.getWebDavClient(repLoc);
                if (client == null) {
                    client = WebDavClientFactory.createClient(new URL(repLoc));
                    WebDavServerCache.cacheWebDavClient(repLoc, client);
                }
                try {
                    res = client.createResource(fullPath, new ByteArrayInputStream(new byte[0]), false);
                    if (res) {
                        client.putResource(fullPath, selectedFile.getContents());
                    }
                }
                catch (WebDavException wde) {
                    if (wde.getErrorCode() != 401) {
                        throw wde;
                    }
                    boolean retry = PlatformUtils.getInstance().authenticateForServer(repLoc, client);
                    if (!retry || !(res = client.createResource(fullPath, new ByteArrayInputStream(new byte[0]), false))) break block8;
                    client.putResource(fullPath, selectedFile.getContents());
                }
            }
            if (res) {
                GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)selectedFile);
                ResourceProperties resProps = client.queryProperties(fullPath);
                GuvnorMetadataProps mdProps = new GuvnorMetadataProps(selectedFile.getName(), repLoc, fullPath, resProps.getLastModifiedDate(), resProps.getRevision());
                GuvnorMetadataUtils.setGuvnorMetadataProps(selectedFile.getFullPath(), mdProps);
            }
        }
        catch (Exception e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
        return res;
    }

    private static void setProjectPropertyForControlledResource(IFile selectedFile) throws Exception {
        IProject project = selectedFile.getProject();
        String value = project.getPersistentProperty(CONTROLLED_PROJECT_PROPERTY);
        if (value == null) {
            project.setPersistentProperty(CONTROLLED_PROJECT_PROPERTY, "true");
        }
    }

    public static void commitFileChanges(IFile selectedFile) {
        try {
            ResourceProperties remoteProps;
            IWebDavClient client;
            GuvnorMetadataProps props;
            block9: {
                props = GuvnorMetadataUtils.getGuvnorMetadata((IResource)selectedFile);
                client = WebDavServerCache.getWebDavClient(props.getRepository());
                if (client == null) {
                    client = WebDavClientFactory.createClient(new URL(props.getRepository()));
                    WebDavServerCache.cacheWebDavClient(props.getRepository(), client);
                }
                remoteProps = null;
                try {
                    remoteProps = client.queryProperties(props.getFullpath());
                }
                catch (WebDavException wde) {
                    if (wde.getErrorCode() != 401) {
                        throw wde;
                    }
                    boolean retry = PlatformUtils.getInstance().authenticateForServer(props.getRepository(), client);
                    if (!retry) break block9;
                    remoteProps = client.queryProperties(props.getFullpath());
                }
            }
            if (remoteProps == null) {
                throw new Exception("Could not retrieve server version of " + props.getFullpath());
            }
            boolean proceed = true;
            if (!props.getRevision().equals(remoteProps.getRevision())) {
                String msg = MessageFormat.format(Messages.getString("overwrite.confirmation"), selectedFile.getName(), remoteProps.getRevision(), props.getRevision());
                Display display = PlatformUI.getWorkbench().getDisplay();
                proceed = MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)Messages.getString("overwrite.confirmation.caption"), (String)msg);
            }
            if (proceed) {
                client.putResource(props.getFullpath(), selectedFile.getContents());
                GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)selectedFile);
                ResourceProperties resProps = client.queryProperties(props.getFullpath());
                GuvnorMetadataProps mdProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)selectedFile);
                mdProps.setVersion(resProps.getLastModifiedDate());
                mdProps.setRevision(resProps.getRevision());
                GuvnorMetadataUtils.setGuvnorMetadataProps(selectedFile.getFullPath(), mdProps);
            }
        }
        catch (Exception e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
    }

    public static IFile findGuvnorMetadata(IPath resource) {
        IFile res = null;
        IPath dir = resource.removeLastSegments(1);
        IPath mdpath = dir.append(".guvnorinfo").append("." + resource.lastSegment());
        IResource mdResource = Activator.getDefault().getWorkspace().getRoot().findMember(mdpath);
        if (mdResource != null && mdResource.exists() && mdResource instanceof IFile) {
            res = (IFile)mdResource;
        }
        return res;
    }

    public static boolean isGuvnorControlledResource(IResource resource) {
        return GuvnorMetadataUtils.findGuvnorMetadata(resource) != null;
    }

    public static GuvnorMetadataProps loadGuvnorMetadata(IFile mdFile) throws Exception {
        GuvnorMetadataUtils.setProjectPropertyForControlledResource(mdFile);
        if (!mdFile.isTeamPrivateMember()) {
            mdFile.setTeamPrivateMember(true);
            mdFile.setDerived(true);
            if (mdFile.getParent().getName().endsWith(".guvnorinfo")) {
                mdFile.getParent().setTeamPrivateMember(true);
                mdFile.getParent().setDerived(true);
            }
        }
        Properties props = new Properties();
        try (InputStream contents = mdFile.getContents();){
            props.load(contents);
            GuvnorMetadataProps guvnorMetadataProps = new GuvnorMetadataProps(props.getProperty("filename"), props.getProperty("repository"), props.getProperty("fullpath"), props.getProperty("lastmodified"), props.getProperty("revision"));
            return guvnorMetadataProps;
        }
    }

    public static GuvnorMetadataProps getGuvnorMetadata(IResource resource) throws Exception {
        IFile mdFile = GuvnorMetadataUtils.findGuvnorMetadata(resource);
        if (mdFile == null) {
            return null;
        }
        return GuvnorMetadataUtils.loadGuvnorMetadata(mdFile);
    }

    public static void writeGuvnorMetadataProps(File mdFile, GuvnorMetadataProps mdProps) throws Exception {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(mdFile);
            Properties props = new Properties();
            props.put("repository", mdProps.getRepository());
            props.put("fullpath", mdProps.getFullpath());
            props.put("filename", mdProps.getFilename());
            props.put("lastmodified", mdProps.getVersion());
            props.put("revision", mdProps.getRevision());
            props.store(fos, null);
            fos.flush();
        }
    }

    public static void setGuvnorMetadataProps(IPath controlledFile, GuvnorMetadataProps mdProps) throws Exception {
        IWorkspaceRoot root = Activator.getDefault().getWorkspace().getRoot();
        IFolder mdFolder = root.getFolder(controlledFile.removeLastSegments(1).append(".guvnorinfo"));
        if (!mdFolder.exists()) {
            mdFolder.create(true, true, null);
            mdFolder.setTeamPrivateMember(true);
            mdFolder.setDerived(true);
        }
        IFile mdFile = root.getFile(mdFolder.getFullPath().append("." + controlledFile.lastSegment()));
        Properties props = new Properties();
        if (!mdFile.exists()) {
            mdFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            mdFile.setTeamPrivateMember(true);
            mdFile.setDerived(true);
        } else {
            props.load(mdFile.getContents());
        }
        if (mdProps.getRepository() != null) {
            props.put("repository", mdProps.getRepository());
        }
        if (mdProps.getFullpath() != null) {
            props.put("fullpath", mdProps.getFullpath());
        }
        if (mdProps.getFilename() != null) {
            props.put("filename", mdProps.getFilename());
        }
        if (mdProps.getVersion() != null) {
            props.put("lastmodified", mdProps.getVersion());
        }
        if (mdProps.getRevision() != null) {
            props.put("revision", mdProps.getRevision());
        }
        try (OutputStream os = null;){
            os = new FileOutputStream(new File(mdFile.getLocation().toOSString()));
            props.store(os, null);
            os.flush();
        }
        mdFolder.refreshLocal(2, null);
    }

    public static IPath createGuvnorMetadataLocation(String rootPath) throws Exception {
        Path path = new Path(String.valueOf(rootPath) + File.separator + ".guvnorinfo");
        if (!path.toFile().exists() && !path.toFile().mkdir()) {
            throw new Exception("Could not create directory " + path.toOSString());
        }
        return path;
    }

    public static File getGuvnorMetadataFile(String path, String fname) {
        return new File(String.valueOf(path) + File.separator + "." + fname);
    }

    public static IFile getGuvnorControlledResource(IResource resource) throws Exception {
        IFile res = null;
        if (resource instanceof IFile) {
            Properties props = new Properties();
            props.load(((IFile)resource).getContents());
            if (props.getProperty("filename") != null) {
                res = (IFile)Activator.getDefault().getWorkspace().getRoot().findMember(resource.getFullPath().removeLastSegments(2).append(props.getProperty("filename")));
            }
        }
        return res;
    }

    public static boolean isGuvnorMetadata(IResource resource) {
        return resource.getFullPath().removeLastSegments(1).toOSString().endsWith(".guvnorinfo");
    }

    public static void markCurrentGuvnorResource(IResource resource) throws CoreException {
        resource.setPersistentProperty(GuvnorMetadataUtils.generateQualifiedName("version"), "current");
    }

    public static void markExpiredGuvnorResource(IResource resource) throws CoreException {
        resource.setPersistentProperty(GuvnorMetadataUtils.generateQualifiedName("version"), "expired");
    }

    public static String getGuvnorResourceProperty(IResource resource) throws CoreException {
        return resource.getPersistentProperty(GuvnorMetadataUtils.generateQualifiedName("version"));
    }

    public static boolean isGuvnorResourceCurrent(IResource resource) throws CoreException {
        String ver = resource.getPersistentProperty(GuvnorMetadataUtils.generateQualifiedName("version"));
        if (ver == null) {
            return false;
        }
        return ver.equals("current");
    }

    private static QualifiedName generateQualifiedName(String attr) {
        return new QualifiedName("org.guvnor.tools", attr);
    }

    public static ResourceHistoryEntry[] parseHistoryProperties(Properties entryProps) {
        ResourceHistoryEntry[] entries = new ResourceHistoryEntry[entryProps.size()];
        Enumeration<Object> en = entryProps.keys();
        int i = 0;
        while (i < entryProps.size()) {
            String oneRevision = (String)en.nextElement();
            String val = entryProps.getProperty(oneRevision);
            StringTokenizer tokens = new StringTokenizer(val, ",");
            String verDate = null;
            String author = null;
            String comment = null;
            try {
                verDate = tokens.nextToken();
                author = tokens.nextToken();
                comment = tokens.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {}
            entries[i] = new ResourceHistoryEntry(oneRevision, verDate, author, comment);
            ++i;
        }
        return entries;
    }
}

